package ir.iiscenter.shub;


import android.content.Context;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import java.io.FileReader;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.mockStatic;


/**
 * Example local unit test, which will execute on the development machine (host).
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */

@RunWith(PowerMockRunner.class)
@PrepareForTest({Config.class ,Context.class})
public class UtilUnitTest {
    private String homeUrl;
    private String informationUrl;
    private String signInUrl;
    private String signOutUrl;
    private String joinnUrl;
    private String persianFontPath;
    private int applicationExitCode;
    private String usingMobileAppCookie;
    private String userAgentDescription;
    private int informationReceiverTimeout;
    private boolean showDesktopVersion;
    private String defaultLanguageTag;
    private String initialHost;
    private String downloadFolder;
    private boolean supportSubDomain;
    private Information information = null;
    @Mock
    Config config;
    @Mock
    Context context;
    @Before
    public void setup() {
// preparing the data by making the mock
        mockStatic(Config.class);
        mock(Context.class);
        setConfigFile();
        when(Config.getInstance(context)).thenReturn(config);
        when(Config.getInstance(context).getHomeUrl()).thenReturn(homeUrl);
        when(Config.getInstance(context).getInformationUrl()).thenReturn(informationUrl);
        when(Config.getInstance(context).getPersianFontPath()).thenReturn(persianFontPath);
        when(Config.getInstance(context).getApplicationExitCode()).thenReturn(applicationExitCode);
        when(Config.getInstance(context).getUsingMobileAppCookie()).thenReturn(usingMobileAppCookie);
        when(Config.getInstance(context).getUserAgentDescription()).thenReturn(userAgentDescription);
        when(Config.getInstance(context).getInformationReceiverTimeout()).thenReturn(informationReceiverTimeout);
        when(Config.getInstance(context).isShowDesktopVersion()).thenReturn(showDesktopVersion);
        when(Config.getInstance(context).isSupportSubDomain()).thenReturn(supportSubDomain);
        when(Config.getInstance(context).getDefaultLanguageTag()).thenReturn(defaultLanguageTag);
        when(Config.getInstance(context).getDownloadFolder()).thenReturn(downloadFolder);
        when(Config.getInstance(context).getSignInUrl()).thenReturn(signInUrl);
        when(Config.getInstance(context).getSignOutUrl()).thenReturn(signOutUrl);
        when(Config.getInstance(context).getJoinnUrl()).thenReturn(joinnUrl);
    }

    private void setConfigFile()
    {
        JSONParser parser = new JSONParser();
        try{
            Object jsonObject = parser.parse(new FileReader(
                    "../app/src/main/assets/config.json"));

            JSONObject obj = (JSONObject) jsonObject;
            JSONArray config_items = (JSONArray) obj.get("config");
            JSONObject items=(JSONObject)config_items.get(0);
            if(items.get("home_url") != null && !((String) items.get("home_url")).isEmpty()) {
                homeUrl = (String) items.get("home_url");
            }
            if(items.get("information_url") != null && !((String) items.get("information_url")).isEmpty()) {
                informationUrl = (String) items.get("information_url");
            }
            if(items.get("persian_font_asset_path") != null && !((String) items.get("persian_font_asset_path")).isEmpty()) {
                persianFontPath = (String) items.get("persian_font_asset_path");
            }
            if(items.get("application_exit_code") != null ) {
                applicationExitCode = Integer.parseInt((String) items.get("application_exit_code"));
            }
            if(items.get("using_mobile_cookie_label") != null && !((String) items.get("using_mobile_cookie_label")).isEmpty()) {
                usingMobileAppCookie = (String) items.get("using_mobile_cookie_label");
            }
            if(items.get("user_agent_description") != null && !((String) items.get("user_agent_description")).isEmpty()) {
                userAgentDescription = (String) items.get("user_agent_description");
            }
            if(items.get("information_receiver_timeout") != null) {
                informationReceiverTimeout = Integer.parseInt((String) items.get("information_receiver_timeout"));
            }
            if(items.get("show_desktop_version") != null ) {
                showDesktopVersion = Boolean.valueOf((String) items.get("show_desktop_version"));
            }
            if(items.get("support_subdomain") != null ) {
                supportSubDomain = Boolean.valueOf((String) items.get("support_subdomain"));
            }
            if(items.get("default_language_tag") != null && !((String) items.get("default_language_tag")).isEmpty()) {
                defaultLanguageTag = UTIL.getMainTagOfLocale((String) items.get("default_language_tag"));
            }
            if(items.get("download_folder") != null && !((String) items.get("download_folder")).isEmpty()) {
                downloadFolder = (String) items.get("download_folder");
            }
            if(items.get("sign_in_url") != null && !((String) items.get("sign_in_url")).isEmpty()) {
                signInUrl = (String) items.get("sign_in_url");
            }
            if(items.get("sign_out_url") != null && !((String) items.get("sign_out_url")).isEmpty()) {
                signOutUrl = (String) items.get("sign_out_url");
            }
            if(items.get("join_url") != null && !((String) items.get("join_url")).isEmpty()) {
                joinnUrl = (String) items.get("join_url");
            }
            config.setInitialHost();
        }catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Test
    public void isInMenuBlackListTest(){

        boolean result1 = UTIL.isInMenuBlackList(config.getHomeUrl() +"/desktop-version", context);
        Assert.assertEquals("This test must return true",true,result1);

        boolean result2 = UTIL.isInMenuBlackList(config.getHomeUrl() +"/photo", context);
        Assert.assertEquals("This test must return false",false,result2);
    }

    @Test
    public void getMainTagOfLocaleTest(){
        String tag = "this-is-test";
        String result = UTIL.getMainTagOfLocale(tag);
        Assert.assertEquals("This test must return true","this",result);
    }

    @Test
    public void getMenuIconTest(){
        String href = config.getHomeUrl()+"/forum";
        long result = UTIL.getMenuIcon(href);
        Assert.assertNotEquals("This test must return number not equal",R.drawable.ic_menu_other,result);

        href = config.getHomeUrl()+"/JJUUTT";
        result = UTIL.getMenuIcon(href);
        Assert.assertEquals("This test must return number equal",R.drawable.ic_menu_other,result);
    }

    @Test
    public void isInArrayOfExtensionsTest(){
        String search = "test.jpg";
        Boolean result = UTIL.isInArrayOfExtensions(search);
        Assert.assertEquals("This test must return true",true,result);

        search = "test.test";
        result = UTIL.isInArrayOfExtensions(search);
        Assert.assertNotEquals("This test must return true",true,result);
    }
}