package ir.iiscenter.shub;

import android.content.Context;
import android.net.Uri;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created by Alimardani on 10/9/2016.
 */

public class Config {
    private static Config mInstance = null;
    private Context mainActivity = null;
    private String homeUrl;
    private String informationUrl;
    private String signInUrl;
    private String signOutUrl;
    private String joinnUrl;
    private String persianFontPath;
    private int applicationExitCode;
    private String usingMobileAppCookie;
    private String userAgentDescription;
    private int informationReceiverTimeout;
    private boolean showDesktopVersion;
    private String defaultLanguageTag;
    private String initialHost;
    private String downloadFolder;
    private boolean supportSubDomain;
    private Information information = null;
    private MyMenuItem updateItem = null;
    private boolean seenUpdate = false;

    private Config(Context context) {

        setMainActivity(context);
        String json = null;

        //Read config from json file.
        try {
            InputStream is = getMainActivity().getAssets().open("config.json");
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");

            JSONObject obj = new JSONObject(json);
            JSONObject config_items = obj.getJSONArray("config").getJSONObject(0);

            setHomeUrl(config_items.getString("home_url"));
            setInformationUrl(config_items.getString("information_url"));
            setPersianFontPath(config_items.getString("persian_font_asset_path"));
            setApplicationExitCode(config_items.getInt("application_exit_code"));
            setUsingMobileAppCookie(config_items.getString("using_mobile_cookie_label"));
            setUserAgentDescription(config_items.getString("user_agent_description"));
            setInformationReceiverTimeout(config_items.getInt("information_receiver_timeout"));
            setShowDesktopVersion(config_items.getBoolean("show_desktop_version"));
            setSupportSubDomain(config_items.getBoolean("support_subdomain"));
            setDefaultLanguageTag(UTIL.getMainTagOfLocale(config_items.getString("default_language_tag")));
            setDownloadFolder(config_items.getString("download_folder"));
            setSignInUrl(config_items.getString("sign_in_url"));
            setSignOutUrl(config_items.getString("sign_out_url"));
            setJoinnUrl(config_items.getString("join_url"));
            setInitialHost();
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Config getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new Config(context);
        }
        return mInstance;
    }

    public boolean isSupportSubDomain() {
        return supportSubDomain;
    }

    public void setSupportSubDomain(boolean supportSubDomain) {
        this.supportSubDomain = supportSubDomain;
    }

    public void setSignInUrl(String signInUrl) {
        this.signInUrl = getHomeUrl() + signInUrl;
    }

    public String getSignInUrl() {
        return signInUrl;
    }

    public void setSignOutUrl(String signOutUrl) {
        this.signOutUrl = getHomeUrl() + signOutUrl;
    }

    public String getSignOutUrl() {
        return signOutUrl;
    }

    public void setJoinnUrl(String joinnUrl) {
        this.joinnUrl = getHomeUrl() + joinnUrl;
    }

    public String getJoinnUrl() {
        return joinnUrl;
    }

    public void setInformationUrl(String informationUrl) {
        this.informationUrl = getHomeUrl() + informationUrl;
    }

    public String getInformationUrl() {
        return informationUrl;
    }

    public void setDownloadFolder(String downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    public String getDownloadFolder() {
        return downloadFolder;
    }

    public void setMainActivity(Context mainActivity) {
        this.mainActivity = mainActivity;
    }

    public Context getMainActivity() {
        return mainActivity;
    }

    public void setHomeUrl(String homeUrl) {
        this.homeUrl = homeUrl;
    }

    public String getHomeUrl() {
        return homeUrl;
    }

    public void setPersianFontPath(String persianFontPath) {
        this.persianFontPath = persianFontPath;
    }

    public String getPersianFontPath() {
        return persianFontPath;
    }

    public void setApplicationExitCode(int applicationExitCode) {
        this.applicationExitCode = applicationExitCode;
    }

    public int getApplicationExitCode() {
        return applicationExitCode;
    }

    public void setUsingMobileAppCookie(String usingMobileAppCookie) {
        this.usingMobileAppCookie = usingMobileAppCookie;
    }

    public String getUsingMobileAppCookie() {
        return usingMobileAppCookie;
    }

    public void setUserAgentDescription(String userAgentDescription) {
        this.userAgentDescription = userAgentDescription;
    }

    public String getUserAgentDescription() {
        return userAgentDescription;
    }

    public void setInformationReceiverTimeout(int informationReceiverTimeout) {
        this.informationReceiverTimeout = informationReceiverTimeout;
    }

    public int getInformationReceiverTimeout() {
        return informationReceiverTimeout;
    }

    public void setShowDesktopVersion(boolean showDesktopVersion) {
        this.showDesktopVersion = showDesktopVersion;
    }

    public boolean isShowDesktopVersion() {
        return showDesktopVersion;
    }

    public void setDefaultLanguageTag(String defaultLanguageTag) {
        this.defaultLanguageTag = defaultLanguageTag;
    }

    public String getDefaultLanguageTag() {
        return defaultLanguageTag;
    }

    public void setInitialHost() {
        // HACK
        initialHost = Uri.parse(getHomeUrl()).getHost();
        if (initialHost.startsWith("www.")) {
            initialHost = initialHost.substring(4);
        }
    }

    public String getInitialHost() {
        return initialHost;
    }

    public void setInformation(Information information) {
        this.information = information;
    }

    public Information getInformation() {
        return information;
    }

    public MyMenuItem getUpdateItem() {
        return updateItem;
    }

    public void setUpdateItem(MyMenuItem updateItem) {
        this.updateItem = updateItem;
    }

    public boolean isSeenUpdate() {
        return seenUpdate;
    }

    public void setSeenUpdate(boolean seenUpdate) {
        this.seenUpdate = seenUpdate;
    }
}