package ir.iiscenter.shub;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;

@SuppressWarnings("deprecation")
public class CookieUtils {
    public static void flushCookies() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    public static void createInstance(Context context){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //Do nothing
        } else {
            CookieSyncManager.createInstance(context);
        }
    }

    public static void startSync(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //Do nothing
        } else {
            CookieSyncManager.getInstance().startSync();
        }
    }

    public static void stopSync(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //Do nothing
        } else {
            CookieSyncManager.getInstance().stopSync();
        }
    }

    private static SharedPreferences getSharedPreference(Context context) {
        return context.getSharedPreferences("Cookie_preferences", Context.MODE_PRIVATE);
    }

    public static void storeCookiesInSharedPreferences(Context context) {
        if (!isCookieEmpty(context)) {
            String cookie = CookieManager.getInstance().getCookie(Config.getInstance(context).getHomeUrl());
            getSharedPreference(context).edit().putString("cookie", cookie).apply();
        }
    }

    public static boolean isCookieEmpty(Context context) {
        String cookie = CookieManager.getInstance().getCookie(Config.getInstance(context).getHomeUrl());
        if (cookie == null) {
            return true;
        } else
            return false;
    }

    public static boolean isSharedPreferencesEmpty(Context context) {
        if (getSharedPreference(context).contains("cookie"))
            return false;
        else
            return true;
    }

    public static void retrieveCookiesFromSharedPreferences(Context context) {
        if (!isSharedPreferencesEmpty(context)) {
            CookieManager.getInstance().removeAllCookie();
            String[] cookieList = getSharedPreference(context).getString("cookie", "").split(";");
            for (String cookie : cookieList)
                CookieManager.getInstance().setCookie(Config.getInstance(context).getHomeUrl(), cookie);
            flushCookies();
        }
    }
}
