//
//  Config.swift
//  shub
//
//  Created by Yaser Alimardany on 10/11/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import Foundation
import UIKit
class Config{
    var homeUrl: String = ""
    var signOutUrl: String = ""
    var signInUrl: String = ""
    var joinUrl: String = ""
    var informationUrl: String = ""
    var persianFont: String = ""
    var usingMobileCookieLabel: String = ""
    var userAgentDescription: String = ""
    var embedUrlSupport: String = ""
    var showDesktopVersion: Bool = false
    var supportSubDomain: Bool = false
    var isRtl: Bool = true
    var information: Information? = nil
    var leftViewController: LeftMenuController? = nil
    var rightViewController: RightMenuController? = nil
    var navigationController: NavigationController? = nil
    var homeViewController: HomeViewController? = nil
    var leftMenuButton: UIBarButtonItem? = nil
    var rightMenuButton: UIBarButtonItem? = nil
    var rootViewController: RootViewController? = nil
    
    static let sharedInstance : Config = {
        let instance = Config()
        return instance
    }()
    
    init(){
        let path = "config"
        
        if let path = Bundle.main.path(forResource: path, ofType: "json") {
            do {
                let data = try Data(contentsOf: URL(fileURLWithPath: path), options: .alwaysMapped)
                
                let json = try! JSONSerialization.jsonObject(with: data, options: JSONSerialization.ReadingOptions.allowFragments) as! [String:AnyObject]
            
                if json["config"] != nil{
                    let configJson = json["config"] as! NSArray
                    let config = configJson[0] as! [String: AnyObject]
                    if let _ = config["home_url"]{
                        self.homeUrl = config["home_url"]! as! String
                    }
                    
                    if let _ = config["sign_in_url"]{
                        self.signInUrl = config["sign_in_url"]! as! String
                    }
                    
                    if let _ = config["join_url"]{
                        self.joinUrl = config["join_url"]! as! String
                    }
                    
                    if let _ = config["sign_out_url"]{
                        self.signOutUrl = config["sign_out_url"]! as! String
                    }
                    
                    if let _ = config["information_url"]{
                        self.informationUrl = config["information_url"]! as! String
                    }
                    
                    if let _ = config["persian_font"]{
                        self.persianFont = config["persian_font"]! as! String
                    }
                    
                    if let _ = config["using_mobile_cookie_label"]{
                        self.usingMobileCookieLabel = config["using_mobile_cookie_label"]! as! String
                    }
                    
                    if let _ = config["user_agent_description"]{
                        self.userAgentDescription = config["user_agent_description"]! as! String
                    }
                    
                    if let _ = config["embed_url_support"]{
                        self.embedUrlSupport = config["embed_url_support"]! as! String
                    }
                    
                    if let _ = config["show_desktop_version"]{
                        let showDesktopVersionString = config["show_desktop_version"]! as! String
                        if showDesktopVersionString == "true"{
                            self.showDesktopVersion = true
                        }
                    }
                    
                    if let _ = config["support_subdomain"]{
                        let supportSubDomainString = config["support_subdomain"]! as! String
                        if supportSubDomainString == "true"{
                            self.supportSubDomain = true
                        }
                    }
                    
                    if let _ = config["is_rtl"]{
                        let is_rtl = config["is_rtl"]! as! String
                        if is_rtl == "1"{
                            self.isRtl = true
                        }else{
                            self.isRtl = false
                        }
                    }
                }
            } catch let error {
                print(error.localizedDescription)
            }
        } else {
            print("Invalid filename/path.")
        }
    }
    
    func getHomeUrl() -> String{
        return self.homeUrl
    }
    
    func getSignOutUrl() -> String{
        return self.homeUrl + self.signOutUrl
    }
    
    func getSignInUrl() -> String{
        return self.homeUrl + self.signInUrl
    }
    
    func getJoinUrl() -> String{
        return self.homeUrl + self.joinUrl
    }
    
    func getInformationUrl() -> String{
        return self.homeUrl + self.informationUrl
    }
    
    func getPersianFont() -> String{
        return self.persianFont
    }
    
    func getUsingMobileCookieLabel() -> String{
        return self.usingMobileCookieLabel
    }
    
    func getUserAgentDescription() -> String{
        return self.userAgentDescription
    }
    
    func getEmbedUrlSupport() -> String{
        return self.embedUrlSupport
    }
    
    func isShowDesktopVersion() -> Bool{
        return self.showDesktopVersion
    }
    
    func isSupportSubDomain() -> Bool{
        return self.supportSubDomain
    }
    
    func isRTL() -> Bool{
        return self.isRtl
    }
}
