//
//  NavigationHelper.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/17/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import Foundation
class NavigationHelper{
    static func isInternalUri(url: URL)-> Bool{
        if url.absoluteString.contains("error.html"){
           return true
        }
        
        let schema: String = url.scheme!
        if !schema.contains("https") && !schema.contains("http"){
            return false
        }
        
        let host: String = url.host!
        let initialHost: String = Util.getInitialHost()
        
        if host == initialHost{
            return true
        }
        
        if Config.sharedInstance.isSupportSubDomain() && host.hasSuffix("."+initialHost){
            return true
        }
        
        return false
    }
    
    static func checkUrlForOverriding(url: URL) -> Bool{
        let urlString: NSString = url.absoluteURL.absoluteString as NSString
        let extenstion: String = urlString.pathExtension
        
        if Util.isDownloadableUrl(string: extenstion) || !NavigationHelper.isInternalUri(url: url){
            if #available(iOS 10.0, *) {
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            } else {
                UIApplication.shared.openURL(url)
            }
            return true
        }
        
        return false
    }
    
    static func isInEmbedUrlSupport(url: URL) -> Bool{
        let absouluteUrl: NSString = url.absoluteString as NSString
        let embedUrlSupportString: String = Config.sharedInstance.getEmbedUrlSupport()
        let embedUrlSupport: [String] = embedUrlSupportString.characters.split(separator: ",").map(String.init)
        if embedUrlSupport.count > 0 {
            for index in 0...embedUrlSupport.count-1{
                let item = embedUrlSupport[index]
                if absouluteUrl.contains(item){
                    return true
                }
            }
        }
        return false
    }
}
