#!/usr/bin/env bash
set -e

echo "`date -Iseconds` Providing access to pluginfiles and userfiles directories..."
mkdir -p /code/ow_pluginfiles /code/ow_userfiles /config /code/ow_log /code/ow_smarty/template_c
chown www-data:www-data /code/ow_pluginfiles /code/ow_userfiles /config /code/ow_log /code/ow_smarty/template_c

echo "`date -Iseconds` Waiting until the database is ready to connect..."
TERM=dumb php -- <<'EOPHP'
<?php
$stderr = fopen('php://stderr', 'w');

$host = getenv('SHUB_DB_HOST');
$port = getenv('SHUB_DB_PORT') ? getenv('SHUB_DB_PORT') : null;
$user = getenv('SHUB_DB_USER');
$pass = getenv('SHUB_DB_PASSWORD');
$name = getenv('SHUB_DB_NAME');

$maxTries = 10;
do {
    $mysql = new mysqli($host, $user, $pass, $name, $port);
    if ($mysql->connect_error) {
        --$maxTries;
        if ($maxTries <= 0) {
            fwrite($stderr, "\n" . 'MySQL Connection Error: (' . $mysql->connect_errno . ') ' . $mysql->connect_error . "\n");
            exit(1);
        }
        sleep(3);
    } else {
        $mysql->close();
    }
} while ($mysql->connect_error);
EOPHP
echo "`date -Iseconds` The database is ready to connect now."

bash /ensure-installed.sh

bash /update.sh
