<?php
/**
 * User: Hamed Tahmooresi
 * Date: 12/23/2015
 * Time: 11:00 AM
 */

$config = OW::getConfig();

if ( !$config->configExists('iissecurityessentials', 'idleTime') )
{
    $config->addConfig('iissecurityessentials', 'idleTime', 20);
}
if ( !$config->configExists('iissecurityessentials', 'viewUserCommentWidget') )
{
    $config->addConfig('iissecurityessentials', 'viewUserCommentWidget', false);
}

if ( !$config->configExists('iissecurityessentials', 'approveUserAfterEditProfile') )
{
    $config->addConfig('iissecurityessentials', 'approveUserAfterEditProfile', false);
}
if ( !$config->configExists('iissecurityessentials', 'disabled_home_page_action_types') )
{
    OW::getConfig()->addConfig('iissecurityessentials', 'disabled_home_page_action_types', '');
}

if ( !$config->configExists('iissecurityessentials', 'newsFeedShowDefault') )
{
    OW::getConfig()->addConfig('iissecurityessentials', 'newsFeedShowDefault', '');
}
if ( !$config->configExists('iissecurityessentials', 'passwordRequiredProfile') )
{
    OW::getConfig()->addConfig('iissecurityessentials', 'passwordRequiredProfile', '');
}

if ( !$config->configExists('iissecurityessentials', 'remember_me_default_value') )
{
    OW::getConfig()->addConfig('iissecurityessentials', 'remember_me_default_value', false);
}

if ( !$config->configExists('iissecurityessentials', 'privacySet') )
{
    $config->addConfig('iissecurityessentials', 'privacySet', false);
}

if ( !$config->configExists('iissecurityessentials', 'privacyUpdateNotification') )
{
    $config->addConfig('iissecurityessentials', 'privacyUpdateNotification', false);
}

if ( !$config->configExists('iissecurityessentials', 'update_all_plugins_activated') )
{
    $config->addConfig('iissecurityessentials', 'update_all_plugins_activated', true);
}
if ( !$config->configExists('iissecurityessentials', 'ie_message_enabled') )
{
    $config->addConfig('iissecurityessentials', 'ie_message_enabled', true);
}
if ( !$config->configExists('iissecurityessentials', 'disable_verify_peer') )
{
    $config->addConfig('iissecurityessentials', 'disable_verify_peer', false);
}

$config->saveConfig('iissecurityessentials', 'disable_user_get_other_sites_content', false);

try {


    $authorization = OW::getAuthorization();
    $groupName = 'iissecurityessentials';
    $authorization->addGroup($groupName);
    $authorization->addAction($groupName, 'security-privacy_alert');
    $authorization->addAction($groupName, 'view-users-list',true);
    $authorization->addAction($groupName, 'customize_user_profile');
    $authorization->addAction($groupName, 'user-can-view-comments',true);

}catch(Exception $e){

}

OW::getDbo()->query("
DROP TABLE IF EXISTS  `' . OW_DB_PREFIX . 'iissecurityessentials_question_privacy`;");

OW::getDbo()->query('CREATE TABLE IF NOT EXISTS `' . OW_DB_PREFIX . 'iissecurityessentials_question_privacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `questionId` int(11) NOT NULL,
  `privacy` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;');

OW::getDbo()->query("
DROP TABLE IF EXISTS  `" . OW_DB_PREFIX . "iissecurityessentials_request_manager`;");
OW::getDbo()->query('CREATE TABLE IF NOT EXISTS `' . OW_DB_PREFIX . 'iissecurityessentials_request_manager` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `senderId` int(11) NOT NULL,
  `receiverId` int(11) NOT NULL,
  `code` varchar(150) NOT NULL,
  `activityType` varchar(100) NOT NULL,
  `expirationTimeStamp` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `senderId` (`senderId`),
  KEY `receiverId` (`receiverId`)
) DEFAULT CHARSET=utf8 ;');
