<?php
/**
 * iisadvancedstyles
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisadvancedstyles
 * @since 1.0
 */

class IISADVANCEDSTYLES_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function __construct()
    {
        parent::__construct();

        if ( OW::getRequest()->isAjax() )
        {
            return;
        }

        $lang = OW::getLanguage();

        $this->setPageHeading($lang->text('iisadvancedstyles', 'admin_settings_title'));
        $this->setPageTitle($lang->text('iisadvancedstyles', 'admin_settings_title'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function settings()
    {
        $lang = OW::getLanguage();

        $adminForm = new Form('adminForm');

        $field = new TextField('input_file');
        $field->setLabel($lang->text('iisadvancedstyles','input_file'));
        $field->setDescription($lang->text('iisadvancedstyles','input_file_desc'));
        $field->addAttribute('style', 'direction:ltr');
        $adminForm->addElement($field);

        $field = new Selectbox('outputFormat');
        $field->setLabel($lang->text('iisadvancedstyles','output_format'));
        $field->addOption('default', 'SCSS');
        $field->setValue('default');
        $adminForm->addElement($field);
        
        $element = new Submit('saveSettings');
        $element->setValue($lang->text('iisadvancedstyles', 'convert'));
        $adminForm->addElement($element);

        $this->addForm($adminForm);

        if ( OW::getRequest()->isPost() ) {
            if ($adminForm->isValid($_POST)) {
                $inpath = $_POST['input_file'];
                $file_list = [];
                if(substr($inpath, 0, 2) == '>>'){
                    $order = substr($inpath, 2);
                    switch ($order){
                        case 'base':
                            $file_list[] = OW::getPluginManager()->getPlugin('base')->getPublicStaticDir() . 'css' . DS . 'ow.scss';
                            break;
                        case 'base_mobile':
                            $file_list[] = OW::getPluginManager()->getPlugin('base')->getPublicStaticDir() . 'css' . DS . 'mobile.scss';
                            break;

                        case 'current_theme':

                            $file_list[] = OW::getThemeManager()->getSelectedTheme()->getRootDir() . 'base.scss';
                            break;
                        case 'current_theme_mobile':
                            $file_list[] = OW::getThemeManager()->getSelectedTheme()->getRootDir(true) . 'base.scss';
                            break;
                        case 'current_theme_static':
                            $file_list[] = OW::getThemeManager()->getSelectedTheme()->getStaticDir() . 'base.scss';
                            break;
                        case 'current_theme_mobile_static':
                            $file_list[] = OW::getThemeManager()->getSelectedTheme()->getStaticDir(true) . 'base.scss';
                            break;

                        case 'all_themes':
                            $themes = BOL_ThemeService::getInstance()->findAllThemes();
                            foreach ( $themes as $theme ) {
                                $file_list[] = BOL_ThemeService::getInstance()->getRootDir($theme->key) . 'base.scss';
                            }
                            break;
                        case 'all_themes_mobile':
                            $themes = BOL_ThemeService::getInstance()->findAllThemes();
                            foreach ( $themes as $theme ) {
                                $file_list[] = BOL_ThemeService::getInstance()->getRootDir($theme->key, true) . 'base.scss';
                            }
                            break;
                        case 'all_themes_static':
                            $themes = BOL_ThemeService::getInstance()->findAllThemes();
                            foreach ( $themes as $theme ) {
                                $file_list[] = BOL_ThemeService::getInstance()->getStaticDir($theme->key) . 'base.scss';
                            }
                            break;
                        case 'all_themes_mobile_static':
                            $themes = BOL_ThemeService::getInstance()->findAllThemes();
                            foreach ( $themes as $theme ) {
                                $file_list[] = BOL_ThemeService::getInstance()->getStaticDir($theme->key, true) . 'base.scss';
                            }
                            break;
                    }
                }else{
                    $inpath = str_replace('\\', DS, $inpath);
                    $inpath = str_replace('/', DS, $inpath);
                    $inpath = OW_DIR_ROOT . $inpath;
                    $file_list[] = $inpath;
                }

                $scss_compiler = new Leafo\ScssPhp\Compiler();
                $scss_compiler->addImportPath(OW_DIR_STATIC_PLUGIN . 'base' . DS . 'css' . DS);
                foreach ($file_list as $inpath) {
                    if (OW::getStorage()->fileExists($inpath)) {
                        $scss_code = file_get_contents($inpath);
                        $result = $scss_compiler->compile($scss_code);
                        $result = "/* Generated by `iisadvancedstyles` plugin */\n\n" . $result;

                        $outpath = substr_replace($inpath, 'css', strrpos($inpath, '.') + 1);
                        file_put_contents($outpath, $result);
                    }
                }
                OW::getFeedback()->info(OW::getLanguage()->text('iisadvancedstyles', 'compiled_success'));
            }
        }
   }
}
