<?php
/**
 * iisadvancedstyles
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisadvancedstyles
 * @since 1.0
 */

class IISADVANCEDSTYLES_MCLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function init()
    {
        $eventManager = OW::getEventManager();
        $eventManager->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, array($this, 'onBeforeDocumentRender'));
    }

    public function onBeforeDocumentRender(OW_Event $event)
    {
        $path = IISADVANCEDSTYLES_BOL_Service::getInstance()->getScssURL(true);
        if (!empty($path)) {
            OW::getDocument()->addStyleSheet($path);
        }
    }
}