<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisadvanceeditor.bol
 * @since 1.0
 */
class IISADVANCEEDITOR_CLASS_EventHandler
{
    const GET_MAX_SYMBOLS_COUNT = "iisadvanceeditor.get.max.symbols.count";
    private static $classInstance;
    private $pluginKey='base';
    private static $stylesheet = "";
    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
        self::$stylesheet = "span.cke_button__ow_image_icon,
            span.cke_button__ow_video_icon,
            span.cke_button__ow_html_icon,
            span.cke_button__ow_switchHtml_icon,
            span.cke_button__ow_more_icon
            { background: url(". OW_URL_STATIC."plugins/base/css/wysiwyg.png ) no-repeat 0 0; }
            
            span.cke_button__ow_image_icon
            { background-position: -178px -2px;}
            span.cke_button__ow_video_icon
            { background-position: -200px -2px;}
            span.cke_button__ow_html_icon
            { background-position: -156px -2px;}
            span.cke_button__ow_switchHtml_icon
            { background-position: -134px -2px;}
            span.cke_button__ow_more_icon
            { background-position: -112px -2px;}
            
            
            iframe.cke_wysiwyg_frame.cke_reset {
                height: 100% !important;
                max-height: initial !important;
            }";
    }

    public function setPluginKey()
    {
        $attr = OW::getRequestHandler()->getHandlerAttributes();

        if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISNEWS') !== false)
        {
            $this->pluginKey='iisnews';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISVITRIN') !== false)
        {
            $this->pluginKey='iisvitrin';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'FORUM') !== false)
        {
            $this->pluginKey='forum';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISCOMPETITION') !== false)
        {
            $this->pluginKey='iiscompetition';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISSLIDESHOW') !== false)
        {
            $this->pluginKey='iisslideshow';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISSLIDESHOW') !== false)
        {
            $this->pluginKey='iisslideshow';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'IISTICKETING') !== false)
        {
            $this->pluginKey='iisticketing';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'BLOGS') !== false)
        {
            $this->pluginKey='blogs';
        }
        else if (strpos($attr[OW_RequestHandler::ATTRS_KEY_CTRL], 'BASE') !== false)
        {
            $this->pluginKey='base';
        }
    }

    public function init()
    {
        $eventManager = OW::getEventManager();
        $eventManager->bind(OW_EventManager::ON_FINALIZE, array($this, 'onFinalize'));
        $eventManager->bind(OW_EventManager::ON_AFTER_ROUTE, array($this, 'onAfterRoute'));
        $eventManager->bind("iisadvanceeditor.get.max.symbols.count",array($this,'onGetMaxSymbolsCount'));
    }

    public function onFinalize(OW_Event $event)
    {
        $requri = OW::getRequest()->getRequestUri();
        $config = OW::getConfig();
        $this->setPluginKey();
        $htmlDisableStatus = false;
        $mediaDisableStatus = false;
        $ck_enabled = false;
        if(OW::getConfig()->getValue('iisadvanceeditor', 'isCustomHtmlWidgetEditorAdvance'))
        {
            $conditionForCustomHtmlWidget = strpos($requri, 'index/customize') !== false;
        }
        else{
            $conditionForCustomHtmlWidget = false;
        }
        if ((strpos($requri, 'edit') !== false && strpos($requri, 'admin') === false) ||
            (strpos($requri, 'add') !== false && strpos($requri, 'admin') === false) ||
            strpos($requri, 'create') !== false ||
            strpos($requri, 'new') !== false ||
            strpos($requri, 'admin/guideline') !== false ||
            strpos($requri, 'admin/questions') !== false ||
            strpos($requri, 'admin/edit-question') !== false ||
            strpos($requri, 'admin/mass-mailing') !== false ||
            strpos($requri, 'iisvitrin/admin') !== false ||
            strpos($requri, 'iisterms/admin') !== false ||
            strpos($requri, 'forum/topic/') !== false ||
            strpos($requri, 'iiscompetition/') !== false ||
            strpos($requri, 'iisslideshow/admin') !== false ||
            strpos($requri, 'iisticketing/ticket') !== false ||
            $conditionForCustomHtmlWidget
        ) {

            $ck_enabled = true;
        }
        if($config->configExists('base','tf_user_custom_html_disable'))
        {
            $htmlDisableStatus= $config->getValue('base','tf_user_custom_html_disable');
        }
        if($config->configExists('base','tf_user_rich_media_disable'))
        {
            $mediaDisableStatus= $config->getValue('base','tf_user_rich_media_disable');
        }
        if ($ck_enabled === true && !$htmlDisableStatus) {
            $mediaPlugins = '';

             if(!$mediaDisableStatus && !(strpos($requri, 'event') !== false
                     || strpos($requri, 'group') !== false
                     || strpos($requri, 'video') !== false)){
                $mediaPlugins = 'ow_video,ow_image';
            }
            $more = "";
            if(!(strpos($requri, 'event') !== false ||
                 strpos($requri, 'group') !== false ||
                 strpos($requri, 'video') !== false)){
                if($mediaPlugins!=''){
                    $more = ",";
                }
                $more .= "ow_more";
            }

            //choose CKEditor language based on user's specified language
            $lang = 'fa';
            $currentLanguageTag = BOL_LanguageService::getInstance()->getCurrent()->getTag();
            if($currentLanguageTag=='en'){
                $lang = 'en';
            }

            OW::getDocument()->addStyleDeclaration(self::$stylesheet);
            OW::getDocument()->addScript(OW_URL_STATIC_PLUGINS . 'iisadvanceeditor/js/ckeditor/ckeditor.js');
            OW::getDocument()->addScript(OW_URL_STATIC_PLUGINS . 'iisadvanceeditor/js/init.js');
            OW::getDocument()->addOnloadScript("
                window.CKCONFIG=
                {
                toolbar: 'Basic',
                customConfig : '',
                ow_imagesUrl : '" . OW::getRouter()->urlFor('BASE_CTRL_MediaPanel', 'index', array('pluginKey' =>   $this->pluginKey, 'id' => '__id__')) . "',
                language : '" . BOL_LanguageService::getInstance()->getCurrent()->getTag() . "',
                disableNativeSpellChecker : false,
                extraPlugins: '" . $mediaPlugins . $more .  "',
                removePlugins : 'image,contextmenu,liststyle,tabletools,tableselection',
                linkShowAdvancedTab : false,
                allowedContent:'h1 h2 h3 h4 h5 h6 ul ol blockquote div p li table tbody tr th td strong em i b u span; a[href,target]; img[src,height,width]; *[id,alt,title,dir]{*}(*); table[*]',
                autoGrow_onStartup: true,
                uiColor: '#fdfdfd',
                language: '$lang'
                };
                iisadvanceeditor_textarea_check();
            ", 900);
        }
    }

    public function onAfterRoute(OW_Event $event)
    {
        OW::getDocument()->addStyleSheet(OW_PluginManager::getInstance()->getPlugin('iisadvanceeditor')->getStaticJsUrl() . 'ckeditor/contents.css');
        OW::getDocument()->addStyleDeclaration(self::$stylesheet);
    }
    public function onGetMaxSymbolsCount(OW_Event $event){
        if(OW::getConfig()->configExists('iisadvanceeditor','MaxSymbolsCount'))
        {
            $msxSymbolsCount = OW::getConfig()->getValue('iisadvanceeditor','MaxSymbolsCount');
            $event->setData(array('maxSymbolsCount' => $msxSymbolsCount));
        }
    }
}