<?php
/**
 * Copyright (c) 2016, Milad Heshmati
 * All rights reserved.
 */

/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisaudio
 * @since 1.0
 */
class IISAUDIO_MCLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    /***
     *
     */
    public function init()
    {
        $service = IISAUDIO_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind(IISEventManager::ON_FEED_ITEM_RENDERER, array($service, 'appendAudioPlayerToFeed'));
        $eventManager->bind(IISEventManager::ON_BEFORE_UPDATE_STATUS_FORM_RENDERER, array($service, 'addAudioInputFieldsToNewsfeed'));
        $eventManager->bind(IISEventManager::ON_BEFORE_FORUM_POST_RENDER, array($service,'AudioRenderInPostForum'));
        $eventManager->bind(IISEventManager::ON_BEFORE_FORUM_POST_FORM_CREATE, array($service,'addAudioInputFieldsToForum'));
        $eventManager->bind('feed.on_entity_action', array($service,'saveInsertedAudio'));
        $eventManager->bind('forum.add_post', array($service,'saveInsertedAudio'));
        $eventManager->bind('base.on.before.forward.status.create', array($service, 'onForward'));
        $eventManager->bind('on.status.update.check.data', array($service, 'onStatusUpdateCheckData'));
    }
}