<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisaudio
 * @since 1.0
 */
class IISAUDIO_MCTRL_Audio extends OW_MobileActionController
{
    /***
     * @param $params
     * @throws Redirect404Exception
     */
    public function addAudio($params)
    {
        $form = IISAUDIO_BOL_Service::getInstance()->getAddAudioForm();
        $this->addForm($form);

        if (OW::getRequest()->isAjax()) {
            if ($form->isValid($_POST) && OW::getUser()->isAuthenticated()) {
                $values = $form->getValues();
                $audio = IISAUDIO_BOL_Service::getInstance()->findAudioById($values["audioId"]);
                if($audio==null){
                    exit(json_encode(array('result ' => false)));
                }
                exit(json_encode(array('result' => true, 'audioId' => $audio->id , 'audioData' => IISAUDIO_BOL_Service::getInstance()->getAudioFileUrl($audio->hash), 'name' => $values["name"])));
            }
            exit(json_encode(array('result ' => false)));
        }
        throw new Redirect404Exception();
    }

    /***
     * @param $params
     * @throws Redirect404Exception
     */
    public function viewList($params)
    {
        $this->setPageTitle(OW::getLanguage()->text('iisaudio', 'index_page_title'));
        $this->setPageHeading(OW::getLanguage()->text('iisaudio', 'index_page_heading'));

        $page = (!empty($_GET['page']) && intval($_GET['page']) > 0) ? $_GET['page'] : 1;
        $count = 5;
        $first = ($page - 1) * $count;


        $this->addForm(IISAUDIO_BOL_Service::getInstance()->getAddAudioForm());
        if (OW::getUser()->isAuthenticated()) {
            $service = IISAUDIO_BOL_Service::getInstance();
            $allAudiosListOfUser = IISAUDIO_BOL_Service::getInstance()->findAudiosByUserId(OW::getUser()->getId());
            $sizeOfAllAudiosOfUser = 0;
            if ($allAudiosListOfUser != null) {
                $sizeOfAllAudiosOfUser = sizeof($allAudiosListOfUser);
            }
            $list = IISAUDIO_BOL_Service::getInstance()->findListOrderedByDate(OW::getUser()->getId(), $first, $count);
            $tplList = array();
            foreach ($list as $listItem) {
                $audioForumUrl = null;
                $autherUserName = BOL_UserService::getInstance()->findUserById($listItem->userId)->getUsername();
                $audioType = '';
                if ($listItem->object_type == 'newsfeed') {
                    $audioType = OW::getLanguage()->text('iisaudio', 'newsfeed_audio_located');
                } else if ($listItem->object_type == 'forum-post') {
                    $audioType = OW::getLanguage()->text('iisaudio', 'forum_audio_located');
                    $postDto = FORUM_BOL_ForumService::getInstance()->findPostById($listItem->object_id);
                    if ($postDto != null) {
                        $audioForumUrl = FORUM_BOL_ForumService::getInstance()->getPostUrl($postDto->topicId, $listItem->object_id);
                    }
                }
                $tplList[] = array(
                    "title" => $listItem->title,
                    "autherName" => $autherUserName,
                    "autherUrl" => OW::getRouter()->urlForRoute('base_user_profile', array('username' => $autherUserName)),
                    "addDateTime" => UTIL_DateTime::formatDate($listItem->addDateTime),
                    "audioUrl" => $service->getAudioFileUrl($listItem->hash),
                    "audioType" => $audioType,
                    "audioForumUrl" => $audioForumUrl,
                    'deleteUrl' => "if(confirm('" . OW::getLanguage()->text('iisaudio', 'delete_item_warning') . "')){location.href='" . OW::getRouter()->urlForRoute('iisaudio-audio-delete-item', array('id' => $listItem->getId())) . "';}"
                );
            }
            $this->assign("list", $tplList);
            if(sizeof($tplList)==0){
                $this->assign('isListItemEmpty', true);
            }

            $paging = new BASE_CMP_Paging($page, ceil($sizeOfAllAudiosOfUser / $count), 5);
            $this->addComponent('paging', $paging);
        } else {
            throw new Redirect404Exception();
        }
    }

    public function saveTempItem(){
        if(isset($_POST['data'])) {
            $data = $_POST['data'];
            $audio = IISAUDIO_BOL_Service::getInstance()->saveTempAudio($data);
            if($audio!=null){
                exit(json_encode(array(
                        'result' => true,
                        'id' => $audio->id,
                        'url' => IISAUDIO_BOL_Service::getInstance()->getAudioFileUrl($audio->hash))
                ));
            }
        }
        exit(json_encode(array('result' => false)));
    }

    public function saveTempBlobItem(){
        if(isset($_FILES['file']) and !$_FILES['file']['error']){
            $audio = IISAUDIO_BOL_Service::getInstance()->saveTempBlob($_FILES['file']);
            if($audio!=null){
                exit(json_encode(array(
                        'result' => true,
                        'id' => $audio->id,
                        'url' => IISAUDIO_BOL_Service::getInstance()->getAudioFileUrl($audio->hash))
                ));
            }
        }
        exit(json_encode(array('result' => false)));
    }

    /***
     * @param $params
     * @throws Redirect404Exception
     */
    public function deleteItem($params)
    {
        if (!isset($params['id']) && !OW::getUser()->isAuthenticated()) {
            throw new Redirect404Exception();
        } else {
            $service = IISAUDIO_BOL_Service::getInstance();
            $audio = $service->findAudioById($params['id']);
            if (OW::getUser()->getId() != $audio->userId) {
                throw new Redirect404Exception();
            } else {
                $service->deleteDatabaseRecord($params['id']);
                OW::getFeedback()->info(OW::getLanguage()->text('iisaudio', 'database_record_deleted'));
            }

        }
        $this->redirect(OW::getRouter()->urlForRoute('iisaudio-audio'));
    }
}