<?php
/**
 * @author Hamed Salimian <hamed.salimian94@gmail.com>
 * @package ow_plugins.iiscertedu
 * @since 1.0
 */
final class IISCERTEDU_BOL_Service
{
    private function __construct()
    {
    }

    /***
     * @var
     */
    private static $classInstance;

    /***
     * @return IISCERTEDU_BOL_Service
     */
    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function loadStaticFiles(){
        $jsFile = OW::getPluginManager()->getPlugin('iiscertedu')->getStaticJsUrl() . 'iiscertedu.js';
        OW::getDocument()->addScript($jsFile);

        $countdownJSFile = OW::getPluginManager()->getPlugin('iiscertedu')->getStaticJsUrl() . 'countdown.js';
        OW::getDocument()->addScript($countdownJSFile);

        $cssFile = OW::getPluginManager()->getPlugin('iiscertedu')->getStaticCssUrl() . 'iiscertedu.css';
        OW::getDocument()->addStyleSheet($cssFile);



        $path = $_SERVER['REQUEST_URI'];
        if(preg_match('#^(/(index(/){0,1}){0,1}){0,1}$#', $path, $matches))
        {
            $mainPageCssFile = OW::getPluginManager()->getPlugin('iiscertedu')->getStaticCssUrl() . 'certedu_mainpage.css';
            OW::getDocument()->addStyleSheet($mainPageCssFile);
        }
    }
}