<?php
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iiscfp.controllers
 * @since 1.0
 */
class IISCFP_CMP_FileUploadFloatBox extends OW_Component
{
    public function __construct($iconClass, $eventId)
    {
        $eventDto = IISCFP_BOL_Service::getInstance()->findEvent($eventId);
        if (!isset($eventDto))
        {
            throw new Redirect404Exception();
        }
        parent::__construct();
        $form = IISCFP_BOL_Service::getInstance()->getUploadFileForm($eventId);
        OW::getDocument()->setTitle(OW::getLanguage()->text('iiscfp','add_file'));
        OW::getDocument()->setHeading(OW::getLanguage()->text('iiscfp','add_file'));
        $this->assign('loaderIcon',$this->getIconUrl('LoaderIcon'));
        $this->addForm($form);
    }

    public function getIconUrl($name){
        return OW::getPluginManager()->getPlugin('iiscfp')->getStaticUrl(). 'images/'.$name.'.svg';
    }
}


