<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iischallenge.bol
 * @since 1.0
 */
class IISCHALLENGE_BOL_UserDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISCHALLENGE_BOL_User';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iischallenge_user';
    }

    public function addUserPoint($userId, $point){
        $user = null;
        if($userId != null) {
            $user = $this->findByUserId($userId);
            if ($user == null) {
                $user = new IISCHALLENGE_BOL_User();
                $user->userId = $userId;
            }
            $user->point = $user->point + $point;
        }
        $this->save($user);
        return $user;
    }

    public function findByUserId($userId){
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);
        return $this->findObjectByExample($example);
    }

    public function getUsersPoint($count = 10){
        $example = new OW_Example();
        $example->setOrder('point DESC');
        $example->setLimitClause(0, $count);
        return $this->findListByExample($example);
    }
}
