<?php
/**
 * Copyright (c) 2019, Milad Heshmati
 * All rights reserved.
 */

/**
 *
 *
 * @author Milad Heshmati
 * @package ow_plugins.iisclamav.bol
 * @since 1.0
 */

class IISCLAMAV_BOL_Service
{

    private static $classInstance;
    
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /***
     * @param OW_Event $event
     * @return bool|void
     */
    public function isFileClean(OW_Event $event) {
        if(!OW::getUser()->isAuthorized('iisclamav','check_file'))
        {
            return;
        }
        $param = $event->getParams();
        $errorMessage=null;
        if (!isset($param['path']) || empty($param['path'])) {
            return;
        }
        $socketDisableDecision = OW_Config::getInstance()->getValue('iisclamav','socket_disable_decision');
        $unknownFilePermission = OW_Config::getInstance()->getValue('iisclamav','unknown_files_permission');
        $path = $param['path'];
        if (is_array($path) && sizeof($path) > 0) {
            $path = $path[0];
        }
        if (empty($path)) {
            return;
        }
        $clean = false;
        $webSocketEnable = false;
        $fileChecked = false;
        $fileCheckedResult = null;
        try {
            if (class_exists('JDecool\ClamAV\ClientFactory')) {
                $clientFactory = new JDecool\ClamAV\ClientFactory();

                $host = OW_Config::getInstance()->getValue('iisclamav','socket_host');
                $port = OW_Config::getInstance()->getValue('iisclamav','socket_port');

                $client = $clientFactory->create($host, $port);
                $analysis = $client->scan($path);
                if (isset($analysis) && isset($analysis->all()[$path])){
                    $webSocketEnable = true;
                    $fileCheckedResult = $analysis->all()[$path];
                    if ($fileCheckedResult) {
                        $fileChecked = true;
                        if ($fileCheckedResult->isClean()) {
                            $clean = true;
                        }
                    }
                }
            }
        }
        catch(InvalidDeamonResponse $e) {
            $errorMessage=$e->getMessage();
        }
        catch (RuntimeException $e) {
            $webSocketEnable = false;
            $errorMessage=$e->getMessage();
        }
        catch (Execption $e) {
            $errorMessage=$e->getMessage();
        }
        if (!$fileChecked && $unknownFilePermission) {
            $clean = true;
        }

        if(!$webSocketEnable && $socketDisableDecision) {
            $clean = true;
        }
        if(!$clean || isset($errorMessage))
        {
            OW::getLogger()->writeLog(OW_Log::NOTICE, 'iisclamav_notice', ['actionType'=>OW_Log::DELETE, 'enType'=>'iisclamav', 'error'=>isset($errorMessage)?$errorMessage:"", 'fileChecked'=>$fileChecked,
                'fileCheckedResult'=>print_r($fileCheckedResult, true),'webSocketEnable'=>$webSocketEnable]);
        }
        $event->setData(array('clean' => $clean, 'result' => $fileCheckedResult, 'webSocketEnable' => $webSocketEnable, 'fileChecked' => $fileChecked,'errorMessage'=>$errorMessage));
    }

    /***
     * @param OW_Event $event
     */
    public function addClamavStaticFiles(OW_Event $event){
        OW::getDocument()->addScript(OW::getPluginManager()->getPlugin('iisclamav')->getStaticJsUrl() . 'iisclamav.js');
        OW::getDocument()->addStyleSheet(OW_PluginManager::getInstance()->getPlugin("iisclamav")->getStaticCssUrl() . 'iisclamav.css');
        OW::getLanguage()->addKeyForJs('iisclamav', 'virus_is_detected');
        OW::getLanguage()->addKeyForJs('iisclamav', 'file_is_clean');
    }

    /***
     * @param OW_Event $event
     */
    public function addFileUploadValidator(OW_Event $event) {
        $param = $event->getParams();
        if (!isset($param['FileField'])) {
            return;
        }
        $FileField=$param['FileField'];
        $FileField->addValidator(new IISCLAMAV_CLASS_FileUploadValidator());
        $event->setData(array('FileField' =>  $FileField));
    }

    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iisclamav' => array(
                    'label' => $language->text('iisclamav', 'auth_group_label'),
                    'actions' => array(
                        'check_file' => $language->text('iisclamav', 'auth_action_label_check_file')
                    )
                )
            )
        );
    }
}
