<?php
/**
 * iisclamav
 */
/**
 * @author Milad Heshmati
 * @package ow_plugins.iisclamav
 * @since 1.0
 */

class IISCLAMAV_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index($params)
    {
        OW::getDocument()->setTitle(OW::getLanguage()->text('iisclamav', 'admin_settings_heading'));
        OW::getDocument()->setHeading(OW::getLanguage()->text('iisclamav', 'admin_settings_heading'));

        $form = new Form("form");
        $configs = OW::getConfig()->getValues('iisclamav');

        $checkFieldPermission = new CheckboxField('unknownFilePermission');
        $checkFieldPermission->setLabel(OW::getLanguage()->text('iisclamav', 'unknown_files_permission'))->setValue($configs['unknown_files_permission']);
        $form->addElement($checkFieldPermission);

        $checkFieldWebSocket = new CheckboxField('webSocketDisableDecision');
        $checkFieldWebSocket->setLabel(OW::getLanguage()->text('iisclamav', 'socket_disable_decision'))->setValue($configs['socket_disable_decision']);
        $form->addElement($checkFieldWebSocket);

        $textFieldHost = new TextField("socketHost");
        $textFieldHost->setLabel(OW::getLanguage()->text('iisclamav', 'host_field'))->setValue($configs['socket_host']);
        $form->addElement($textFieldHost);

        $textFieldPort = new TextField("socketPort");
        $textFieldPort->setLabel(OW::getLanguage()->text('iisclamav', 'port_field'))->setValue($configs['socket_port']);
        $form->addElement($textFieldPort);

        $submit = new Submit('submit');
        $submit->setValue(OW::getLanguage()->text('iisclamav', 'save_btn_label'));
        $form->addElement($submit);

        if ( OW::getRequest()->isPost() && $form->isValid($_POST) )
        {
            $data = $form->getValues();
            OW::getConfig()->saveConfig('iisclamav', 'unknown_files_permission', $data['unknownFilePermission']);
            OW::getConfig()->saveConfig('iisclamav', 'socket_disable_decision', $data['webSocketDisableDecision']);
            OW::getConfig()->saveConfig('iisclamav', 'socket_host', $data['socketHost']);
            OW::getConfig()->saveConfig('iisclamav', 'socket_port', $data['socketPort']);
            OW::getFeedback()->info(OW::getLanguage()->text('iisclamav', 'admin_changed_success'));
        }

        $this->addForm($form);
    }
}