<?php
/**
 * Copyright (c) 2016, Mohammad Aghaabbasloo
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Aghaabbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iisclamav.classes
 * @since 1.0
 */
class IISCLAMAV_MCLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }
    public function init()
    {
        $eventManager = OW::getEventManager();
        $service = IISCLAMAV_BOL_Service::getInstance();
        $eventManager->bind('iisclamav.is_file_clean', array($service, 'isFileClean'));
        $eventManager->bind(IISEventManager::ON_AFTER_UPDATE_STATUS_FORM_RENDERER, array($service, 'addClamavStaticFiles'));
        $eventManager->bind('iisclamav.add.file.upload.validator', array($service, 'addFileUploadValidator'));
    }

}