<?php
/**
 * Copyright (c) 2016, Mohammad Aghaabbasloo
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Aghaabbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iiscommentplus.classes
 * @since 1.0
 */
class IISCOMMENTPLUS_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function init()
    {
        $service = IISCOMMENTPLUS_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind('base_add_comment', array($service, 'iiscommentplus_afterComment_notification'));
        $eventManager->bind('base_delete_comment', array($service, 'deleteComment'));
        $eventManager->bind('feed.after_like_added', array($service, 'onAfterFeedLikeNotification'));
        $eventManager->bind('notifications.collect_actions', array($service, 'notificationActionAdd'));
    }


}