<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iiscompetition.bol
 * @since 1.0
 */
class IISCOMPETITION_BOL_CompetitionUserDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISCOMPETITION_BOL_CompetitionUser';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iiscompetition_competition_user';
    }

    /***
     * @param $competitionId
     * @return array
     */
    public function findCompetitionUsers($competitionId){
        $ex = new OW_Example();
        $ex->andFieldEqual('competitionId', $competitionId);
        $ex->setOrder('`value` DESC');
        return $this->findListByExample($ex);
    }

    /***
     * @param $userId
     * @param $competitionId
     * @param $value
     * @return IISCOMPETITION_BOL_CompetitionUser|mixed
     */
    public function saveCompetitionUsers($userId, $competitionId, $value){
        $ex = new OW_Example();
        $ex->andFieldEqual('competitionId', $competitionId);
        $ex->andFieldEqual('userId', $userId);
        $competitionUser = $this->findObjectByExample($ex);

        if($competitionUser == null){
            $competitionUser = new IISCOMPETITION_BOL_CompetitionUser();
        }

        $competitionUser->value = $value;
        $competitionUser->userId = $userId;
        $competitionUser->competitionId = $competitionId;
        $this->save($competitionUser);
        return $competitionUser;
    }
}
