<?php
/**
 * Main page
 *
 * @author Mohammad
 * @package ow_plugins.iiscontactus.controllers
 * @since 1.0
 */
class IISCONTACTUS_MCTRL_Contact extends OW_MobileActionController
{

    public function index()
    {
        $this->setPageTitle(OW::getLanguage()->text('iiscontactus', 'index_page_title'));
        $this->setPageHeading(OW::getLanguage()->text('iiscontactus', 'index_page_heading'));

        $contactEmails = array();
        $contacts = IISCONTACTUS_BOL_Service::getInstance()->getDepartmentList();
        foreach ( $contacts as $contact )
        {
            /* @var $contact IISCONTACTUS_BOL_Department */
            $contactEmails[$contact->id]['label'] = $contact->label;
            $contactEmails[$contact->id]['email'] = $contact->email;
        }

        $form = new Form('contact_form');
        $text = "";
        $config = OW::getConfig();
        if($config->configExists('iiscontactus','adminComment') && $config->getValue('iiscontactus', 'adminComment') != "") {
            $text= $config->getValue('iiscontactus', 'adminComment');
            $eventForEnglishFieldSupport = new OW_Event('iismultilingualsupport.show.data.in.multilingual', array('adminComment' => $text, 'entityType' => 'iiscontactus', 'display' => 'showAdminComment'));
            OW::getEventManager()->trigger($eventForEnglishFieldSupport);
            if (isset($eventForEnglishFieldSupport->getData()['multiData'])) {
                $text = $eventForEnglishFieldSupport->getData()['multiData'];
            }
            $this->assign('adminComment', $text);
        }
        $fieldTo = new Selectbox('to');
        foreach ( $contactEmails as $id => $value )
        {
            $fieldTo->addOption($id, $value['label']);
        }
        $fieldTo->setRequired();
        $fieldTo->setHasInvitation(false);
        $fieldTo->setLabel($this->text('iiscontactus', 'form_label_to'));
        $form->addElement($fieldTo);

        if ( OW::getUser()->isAuthenticated() )
        {
            $fieldFrom = new HiddenField('from');
            $fieldFrom->setValue( OW::getUser()->getEmail() );
            $this->assign('isAuthenticated', true);
        }else{
            $fieldFrom = new TextField('from');
            $fieldFrom->setLabel($this->text('iiscontactus', 'form_label_from'));
            $this->assign('isAuthenticated', false);
        }
        $fieldFrom->setRequired();
        $fieldFrom->addValidator(new EmailValidator());
        $form->addElement($fieldFrom);

        $fieldSubject = new TextField('subject');
        $fieldSubject->setLabel($this->text('iiscontactus', 'form_label_subject'));
        $fieldSubject->setRequired();
        $form->addElement($fieldSubject);

        $fieldMessage = new Textarea('message');
        $fieldMessage->setLabel($this->text('iiscontactus', 'form_label_message'));
        $fieldMessage->setRequired();
        $form->addElement($fieldMessage);

        $fieldCaptcha = new CaptchaField('captcha');
        $fieldCaptcha->setLabel($this->text('iiscontactus', 'form_label_captcha'));
        $form->addElement($fieldCaptcha);
        $this->assign('captcha_present', 'true');

        $submit = new Submit('send');
        $submit->setValue($this->text('iiscontactus', 'form_label_submit'));
        $form->addElement($submit);

        $this->addForm($form);

        if ( OW::getRequest()->isPost() )
        {
            if ( $form->isValid($_POST) )
            {
                $data = $form->getValues();

                if ( !array_key_exists($data['to'], $contactEmails) )
                {
                    OW::getFeedback()->error($this->text('iiscontactus', 'no_department'));
                    return;
                }

                $mail = OW::getMailer()->createMail();
                $mail->addRecipientEmail($contactEmails[$data['to']]['email']);
                $mail->setSender($data['from']);
                $mail->setSenderSuffix(false);
                $mail->setSubject($data['subject']);
                $mail->setTextContent($data['message']);
                $mail->setHtmlContent($data['message']);
                $iiscontactus = IISCONTACTUS_BOL_Service::getInstance();
                $iiscontactus->addUserInformation($data['subject'],$data['from'],$contactEmails[$data['to']]['label'],$data['message']);
                OW::getMailer()->addToQueue($mail);

                OW::getSession()->set('iiscontactus.dept', $contactEmails[$data['to']]['label']);
                $this->redirectToAction('sent');
            }
        }
    }

    public function sent()
    {
        $this->setPageTitle(OW::getLanguage()->text('iiscontactus', 'index_page_title'));
        $this->setPageHeading(OW::getLanguage()->text('iiscontactus', 'index_page_heading'));
        $dept = null;

        if ( OW::getSession()->isKeySet('iiscontactus.dept') )
        {
            $dept = OW::getSession()->get('iiscontactus.dept');
            OW::getSession()->delete('iiscontactus.dept');
        }
        else
        {
            $this->redirectToAction('index');
        }

        /*$feedback = $this->text('iiscontactus', 'message_sent', ( $dept === null ) ? null : array('dept' => $dept));
        $this->assign('feedback', $feedback);*/
        OW::getFeedback()->info(OW::getLanguage()->text('iiscontactus', 'message_sent', ( $dept === null ) ? null : array('dept' => $dept)));
        $this->redirect(OW::getRouter()->urlForRoute('iiscontactus.index'));

    }

    private function text( $prefix, $key, array $vars = null )
    {
        return OW::getLanguage()->text($prefix, $key, $vars);
    }
}