<?php
/**
 * @author Seyed Ismail Mirvakili
 * Date: 8/27/2017
 * Time: 9:15 AM
 */
class IISFARAPAYAMAK_CTRL_Admin extends ADMIN_CTRL_Abstract
{


    /**
     * IISFRAPAYAMAK_CTRL_Admin constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $language = OW::getLanguage();
        $this->setPageHeading($language->text('iisfarapayamak', 'admin_settings_heading'));
        $this->setPageTitle($language->text('iisfarapayamak', 'admin_settings_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function index(array $params = array())
    {
        $currentSection = '1';

        if (array_key_exists('section', $params)) {
            $currentSection = $params['section'];
        }
        $language = OW::getLanguage();
        $config = OW::getConfig();

        if ($currentSection == '1') {
            $form = new Form('form');
            $field = new Selectbox('provider');
            $field->addOption('REST', 'REST');
            $field->addOption('SOAP', 'SOAP');
            $field->setRequired(true);
            $field->setLabel($language->text('iisfarapayamak', 'provider'));
            if ($config->configExists('iisfarapayamak', 'provider'))
                $field->setValue($config->getValue('iisfarapayamak', 'provider'));
            $form->addElement($field);

            $field = new TextField('panel_username');
            $field->setRequired(true);
            $field->setLabel($language->text('iisfarapayamak', 'panel_username'));
            if ($config->configExists('iisfarapayamak', 'panel_username'))
                $field->setValue($config->getValue('iisfarapayamak', 'panel_username'));
            $form->addElement($field);

            $field = new TextField('panel_password');
            $field->setRequired(true);
            $field->setLabel($language->text('iisfarapayamak', 'panel_password'));
            if ($config->configExists('iisfarapayamak', 'panel_password'))
                $field->setValue($config->getValue('iisfarapayamak', 'panel_password'));
            $form->addElement($field);

            $field = new TextField('panel_number');
            $field->setRequired(true);
            $field->setLabel($language->text('iisfarapayamak', 'panel_number'));
            if ($config->configExists('iisfarapayamak', 'panel_number'))
                $field->setValue($config->getValue('iisfarapayamak', 'panel_number'));
            $form->addElement($field);

            $field = new TextField('provider_soap_url');
            $field->setLabel($language->text('iisfarapayamak', 'provider_soap_url'));
            if ($config->configExists('iisfarapayamak', 'provider_soap_url'))
                $field->setValue($config->getValue('iisfarapayamak', 'provider_soap_url'));
            $form->addElement($field);

            $restUrls = array();
            if ($config->configExists('iisfarapayamak', 'provider_rest_urls')) {
                $rest = $config->getValue('iisfarapayamak', 'provider_rest_urls');
                $restUrls = json_decode($rest, true);
            }

            $field = new TextField('provider_rest_send_sms_url');
            $field->setLabel($language->text('iisfarapayamak', 'provider_rest_send_sms_url'));
            if (isset($restUrls['send_sms']))
                $field->setValue($restUrls['send_sms']);
            $form->addElement($field);

            $field = new TextField('provider_rest_get_credit_url');
            $field->setLabel($language->text('iisfarapayamak', 'provider_rest_get_credit_url'));
            if (isset($restUrls['get_credit']))
                $field->setValue($restUrls['get_credit']);
            $form->addElement($field);

            $field = new TextField('provider_rest_check_status_url');
            $field->setLabel($language->text('iisfarapayamak', 'provider_rest_check_status_url'));
            if (isset($restUrls['check_status']))
                $field->setValue($restUrls['check_status']);
            $form->addElement($field);

            $submit = new Submit('save');
            $form->addElement($submit);

            if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
                $data = $form->getValues();
                if (!$config->configExists('iisfarapayamak', 'provider'))
                    $config->addConfig('iisfarapayamak', 'provider', $data['provider']);
                else
                    $config->saveConfig('iisfarapayamak', 'provider', $data['provider']);

                if (!$config->configExists('iisfarapayamak', 'panel_username'))
                    $config->addConfig('iisfarapayamak', 'panel_username', $data['panel_username']);
                else
                    $config->saveConfig('iisfarapayamak', 'panel_username', $data['panel_username']);

                if (!$config->configExists('iisfarapayamak', 'panel_password'))
                    $config->addConfig('iisfarapayamak', 'panel_password', $data['panel_password']);
                else
                    $config->saveConfig('iisfarapayamak', 'panel_password', $data['panel_password']);

                if (!$config->configExists('iisfarapayamak', 'panel_number'))
                    $config->addConfig('iisfarapayamak', 'panel_number', $data['panel_number']);
                else
                    $config->saveConfig('iisfarapayamak', 'panel_number', $data['panel_number']);

                if (!$config->configExists('iisfarapayamak', 'provider_soap_url'))
                    $config->addConfig('iisfarapayamak', 'provider_soap_url', $data['provider_soap_url']);
                else
                    $config->saveConfig('iisfarapayamak', 'provider_soap_url', $data['provider_soap_url']);

                $restUrls = array(
                    'get_credit' => $data['provider_rest_get_credit_url'],
                    'send_sms' => $data['provider_rest_send_sms_url'],
                    'check_status' => $data['provider_rest_check_status_url']
                );

                if (!$config->configExists('iisfarapayamak', 'provider_rest_urls'))
                    $config->addConfig('iisfarapayamak', 'provider_rest_urls', json_encode($restUrls));
                else
                    $config->saveConfig('iisfarapayamak', 'provider_rest_urls', json_encode($restUrls));

                OW::getFeedback()->info(OW::getLanguage()->text('iisfarapayamak', 'modified_successfully'));
                $this->redirect();
            }
            $this->addForm($form);
        } else {
            $page = 1;
            if(isset($_GET['page'])){
                $page = $_GET['page'];
            }
            $limit = 10;
            $tracks = IISFARAPAYAMAK_BOL_TrackDao::getInstance()->findAllTracks($page,$limit);
            $resultTracks = array();
            foreach ($tracks as $track){
                $result = IISFARAPAYAMAK_BOL_Service::getInstance()->checkSMSStatus($track->smsId);
                $resultTracks[] = array(
                    'text'=>$track->message,
                    'mobile'=>$track->mobile,
                    'time'=>$track->time,
                    'status'=>IISFARAPAYAMAK_BOL_Service::getInstance()->getStatusString($result)
                );
            }
            $this->addComponent('paging', new BASE_CMP_Paging($page, ceil(IISFARAPAYAMAK_BOL_TrackDao::getInstance()->findAllTrackCount() / $limit), 5));
            $this->assign('tracks', $resultTracks);
        }
        $this->assign('section',$currentSection);
        $this->assign('section1_label',OW::getLanguage()->text('iisfarapayamak', 'section1_label'));
        $this->assign('section2_label',OW::getLanguage()->text('iisfarapayamak', 'section2_label'));
        $this->assign('section1_url',OW::getRouter()->urlForRoute('iisfarapayamak_admin_setting_section',array('section'=>1)));
        $this->assign('section2_url',OW::getRouter()->urlForRoute('iisfarapayamak_admin_setting_section',array('section'=>2)));
    }

    public function tracking(){

    }

}