<?php
/**
 * iisfilemanager
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisfilemanager
 * @since 1.0
 */
class IISFILEMANAGER_CTRL_Backend extends OW_ActionController
{

    public function connector($params){
        // run elFinder
        $connector = new IISFILEMANAGER_BOL_CoreConnector(IISFILEMANAGER_BOL_Core::getInstance());
        $connector->run();
        exit('error');
    }

    public function saveToProfile($params){
        if(!OW::getRequest()->isAjax()){
            throw new Redirect404Exception();
        }
        if(empty($_POST['hashes'])){
            exit(json_encode(array('result' => false,
                'message' => OW::getLanguage()->text("iisfilemanager", "failed_to_relocate"))));
        }
        foreach($_POST['hashes'] as $hash) {
            $id = IISFILEMANAGER_BOL_Service::getInstance()->getIdByHash($hash);
            $res = IISFILEMANAGER_BOL_Service::getInstance()->moveToMyProfile($id);
            if (!$res) {
                exit(json_encode(array('result' => false,
                    'message' => OW::getLanguage()->text("iisfilemanager", "failed_to_relocate"))));
            }
        }

        exit(json_encode(array('result' => true,
            'message' => OW::getLanguage()->text("iisfilemanager", "saved_successfully"))));
    }
}
