<?php
/**
 * Copyright (c) 2018, Milad Heshmati
 * All rights reserved.
 */

/**
 *
 *
 * @author Milad Heshmati <Milad.Heshmati@gmail.com>
 * @package ow_plugins.iisgraph.classes
 * @since 1.0
 */
class IISGRAPH_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function addGraphConsoleItem( BASE_CLASS_EventCollector $event )
    {
        $service = IISGRAPH_BOL_Service::getInstance();
        if($service->checkUserPermission() && OW::getUser()->isAuthenticated()) {
            $event->add(array('label' => OW::getLanguage()->text('iisgraph', 'graph_index'), 'url' => OW_Router::getInstance()->urlForRoute('iisgraph.graph')));
        }
    }

    public function init()
    {
        OW::getEventManager()->bind('base.add_main_console_item', array($this, 'addGraphConsoleItem'));
        OW::getEventManager()->bind('admin.add_auth_labels', array($this, "onCollectAuthLabels"));
    }

    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iisgraph' => array(
                    'label' => $language->text('iisgraph', 'auth_iisgraph_label'),
                    'actions' => array(
                        'graphshow' => $language->text('iisgraph', 'auth_action_label_graph')
                    )
                )
            )
        );
    }


}