<?php
/**
 * IIS Graph
 */
/**
 * @author Yaser Alimardani <yaser.alimardani@gmail.com>
 * @package ow_plugins.iisgraph
 * @since 1.0
 */

class IISGRAPH_CMP_TopUsers extends OW_Component
{

    /**
     * IISGRAPH_CMP_TopUsers constructor.
     * @param bool $widget
     * @param int $numberOfAllUsers
     * @param bool $pagination
     * @param int $numberOfResultRows
     */
    public function __construct($widget, $numberOfAllUsers, $pagination, $numberOfResultRows)
    {
        parent::__construct();
        $service = IISGRAPH_BOL_Service::getInstance();
        $service->findTopUsers($this, $numberOfAllUsers, $pagination, $numberOfResultRows, true);
        $toolbarArray[] = array('href' => OW::getRouter()->urlForRoute('iisgraph.top_users'), 'label' => OW::getLanguage()->text('base', 'view_all'));
        $this->assign('toolbars', $toolbarArray);

        if($service->checkUserPermission() && OW::getUser()->isAuthenticated()) {
            $this->assign('top_users_hint', OW::getLanguage()->text('iisgraph', 'top_users_hint'));
        }

        if (!$widget) {
            $this->assign('top_users_header', OW::getLanguage()->text('iisgraph', 'top_users_widget'));
        }
    }

}