<?php
/**
 * IIS Graph
 */
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisgraph
 * @since 1.0
 */

class IISGRAPH_CTRL_Graph extends OW_ActionController
{
    /**
     * IISGRAPH_CTRL_Graph constructor.
     * @throws Redirect404Exception if the user has no access to view the IISGraph pages
     */
    public function __construct()
    {
        if (!OW::getUser()->isAuthorized('iisgraph', 'graphshow') && !OW::getUser()->isAdmin())
            throw new Redirect404Exception();
        $this->setDocumentKey('iisgraph');
    }
    /* ============================ Components ============================ */

    public function index( array $params = array() )
    {
        $adminCmp = new IISGRAPH_CMP_Admin($params, false);
        $this->addComponent('adminCmp',$adminCmp);
    }

    public function graph()
    {
        $graphCmp = new IISGRAPH_CMP_AdminGraph(null, false);
        $this->addComponent('graphCmp',$graphCmp);
    }

    public function userAnalytics()
    {
        $userAnalyticsCmp = new IISGRAPH_CMP_AdminUserAnalytics(null, false);
        $this->addComponent('userAnalyticsCmp',$userAnalyticsCmp);
     }

    public function groupAnalytics()
    {
        $groupAnalyticsCmp = new IISGRAPH_CMP_AdminGroupAnalytics(null, false);
        $this->addComponent('groupAnalyticsCmp',$groupAnalyticsCmp);
    }

    public function userView( array $params = array() )
    {
        $userViewCmp = new IISGRAPH_CMP_AdminUserView($params, false);
        $this->addComponent('userViewCmp',$userViewCmp);
    }

    public function groupView( array $params = array() )
    {
        $groupViewCmp = new IISGRAPH_CMP_AdminGroupView($params, false);
        $this->addComponent('groupViewCmp',$groupViewCmp);
    }

    public function allGroups( array $params = array() )
    {
        $allGroupsCmp = new IISGRAPH_CMP_AdminAllGroups($params, false);
        $this->addComponent('allGroupsCmp',$allGroupsCmp);
    }

    public function oneGroup( array $params = array() )
    {
        $oneGroupCmp = new IISGRAPH_CMP_AdminOneGroup($params, false);
        $this->addComponent('oneGroupCmp',$oneGroupCmp);
    }

    public function allUsers( array $params = array() )
    {
        $allUsersCmp = new IISGRAPH_CMP_AdminAllUsers($params, false);
        $this->addComponent('allUsersCmp',$allUsersCmp);
    }

    public function oneUser( array $params = array() )
    {
        $oneUserCmp = new IISGRAPH_CMP_AdminOneUser($params, false);
        $this->addComponent('oneUserCmp',$oneUserCmp);
    }

    public function usersStatistics( array $params = array() )
    {
        $usersStatistics = new IISGRAPH_CMP_AdminUsersStatistics($params, false);
        $this->addComponent('allUsersStatisticsCmp', $usersStatistics);
    }

    public function usersList( array $params = array() )
    {
        $users_list = new IISGRAPH_CMP_UsersList($params);
        $this->addComponent('allUsersList', $users_list);
    }

    public function calculateAllInformation(){
        $service = IISGRAPH_BOL_Service::getInstance();
        $service->calculateAllInformation();
        OW::getFeedback()->info(OW::getLanguage()->text('iisgraph', 'calculate_all_metrics_successfully'));
        $this->redirect(OW::getRouter()->urlForRoute('iisgraph.graph'));
    }
}
