/**
 * Copyright (c) 2017, Mohammad Reza Heidarian
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Reza Heidarian
 * @package ow_plugins.iisguidedtour
 * @since 1.0
 */

function iisgt_addAttributes(items){
    var i = 0;
    while(i < items.length){
        var myPlacement;
        if(items[i].hasOwnProperty('placement')){
            myPlacement = items[i].placement;
        }
        if(items[i].address){
            if(!$(items[i].address).is(":visible")){
                i++;
                continue;
            }
        }
        iisgt_tour.addStep({
            element: items[i].address,
            content: items[i].description,
            placement: myPlacement,
            title: OW.getLanguageText('iisguidedtour', 'guide_title'),
            onShown: function (tour) {
                // $("div.tour-backdrop").click(function(){
                //     iisgt_cookie_setSeen()
                //     iisgt_tour.end();
                // });
                $(document).keyup(function(e) {
                    if (e.keyCode == 27) { // escape key
                        iisgt_cookie_setSeen()
                        iisgt_tour.end();
                    }
                });
            },
        });
        i++;
    }
}

function iisgt_initializeAndSetOptions(nextPageAddr, previousPageAddr) {
    var buttonNextDef, buttonPreviousDef;
    var endButtonText = 'button_skip';

    if (nextPageAddr){
        buttonNextDef = "<button class='btn btn-warning btn-tour-next-page' data-role='end' onclick='update_seen_status_and_load_page(1, \"" + nextPageAddr + "\")'>" +
            OW.getLanguageText('iisguidedtour', 'button_nextPage') + "</button>";
    }
    else{
        buttonNextDef = '';
        endButtonText = 'end_guided_tour';
    }
    if (previousPageAddr){
        buttonPreviousDef = "<button class='btn btn-warning btn-tour-next-page' data-role='end' onclick='update_seen_status_and_load_page(1, \"" + previousPageAddr + "\")'>" +
            OW.getLanguageText('iisguidedtour', 'button_previousPage') + "</button>";
    }
    else{
        buttonPreviousDef = '';
    }
    iisgt_tour = new Tour({
        smartPlacement: true,
        keyboard: true,
        backdrop: true,
        orphan: true,
        storage: false,
        template: "<div class='popover tour'>" +
        "<div class='arrow'></div>" +
        "<button class='btn btn-warning btn-tour-not-now' data-role='end' onclick='iisgt_cookie_setSeen()'>" + "</button>" +
        "<h3 class='popover-title'></h3>" +
        "<div class='popover-content'></div>" +
        "<div class='popover-navigation'>" +
        "<button class='btn btn-info btn-tour-prev' data-role='prev'>" + OW.getLanguageText('iisguidedtour', 'button_prev') + "</button>" +
        "<button class='btn btn-info btn-tour-next' data-role='next'>" + OW.getLanguageText('iisguidedtour', 'button_next') + "</button>" +
        buttonNextDef +
        buttonPreviousDef +
        "<button class='btn btn-warning btn-tour-end' data-role='end' onclick='iisgt_onEndTour()'>" + OW.getLanguageText('iisguidedtour', endButtonText) + "</button>" +
        "</div>" +
        "</div>",

    });
}

function iisgt_createOneStepGuideForIntroduction() {
    window.oneStepTour = new Tour({
        backdrop: true,
        storage: false,
        template: "<div class='popover tour'>" +
        "<div class='arrow'></div>" +
        "<h3 class='popover-title'></h3>" +
        "<div class='popover-content'></div>" +
        "<div class='popover-navigation'>" +
        "<button class='btn btn-warning btn-tour-next-page' onclick= 'afterIntroductionStep()'>" + OW.getLanguageText('iisguidedtour', 'button_activateGuideline') + "</button>" +
        "<button class='btn btn-warning btn-tour-end' data-role='end' onclick= 'iisgt_onEndTour()'>" + OW.getLanguageText('iisguidedtour', 'button_skip') + "</button>" +
        "</div>" +
        "</div>",
        steps: [
            {
                element: 'a.ow_ic_guidedtour.console_item_guidedtour',
                content: OW.getLanguageText('iisguidedtour', 'index_guideLink'),
                placement: 'right',
            },
        ],
    });

    window.oneStepTour.init();
    window.oneStepTour.start();
}

function iisgt_onEndTour(){
    iisgt_tour = undefined;
    iisgt_setSeen();
}

function iisgt_setSeen() {
    $.ajax({
        url: iisgt_ajax_seen_url,
        type: 'post',
        dataType: 'json',
    });
}

function iisgt_isJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function afterIntroductionStep(){
    window.oneStepTour.end();
    if(typeof window.iisgt_data !== 'undefined') {
        iisgt_applyGuide(iisgt_data.jsonString, iisgt_data.nextPageaddr, iisgt_data.previousPageAddr, 1);
    }
}

function iisgt_applyGuide(jsonString, nextPageAddr, previousPageAddr, seenStatus){

    if (iisgt_isJsonString(jsonString)) {
        window.iisgt_data = {};
        iisgt_data["jsonString"] = jsonString;
        iisgt_data["nextPageaddr"] = nextPageAddr;
        iisgt_data["previousPageAddr"] = previousPageAddr;
        if(typeof iisgt_tour !== 'undefined')
        {
            iisgt_tour.end();
            iisgt_tour = undefined;
        }
        if (seenStatus === 0)
            iisgt_createOneStepGuideForIntroduction();
        else {
            iisgt_initializeAndSetOptions(nextPageAddr, previousPageAddr);
            iisgt_addAttributes(JSON.parse(jsonString));
            iisgt_tour.init();
            iisgt_tour.start();
        }
    }
}

function update_seen_status_and_load_page(status, url) {
    $.ajax({
        url: iisgt_ajax_update_status_url,
        type: 'post',
        dataType: 'json',
        data: {
            status: status,
        },
        success: function()
        {
            location.href = url;
        }
    });
}