<?php
/**
 * Copyright (c) 2016, Mohammad Aghaabbasloo
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Aghaabbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iisinvite.classes
 * @since 1.0
 */
class IISINVITE_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function addConsoleItem( BASE_CLASS_EventCollector $event )
    {
        $service = IISINVITE_BOL_Service::getInstance();
        if($service->checkUserPermission() && OW::getUser()->isAuthenticated()) {
            $event->add(array('label' => OW::getLanguage()->text('iisinvite', 'invite_index'), 'url' => OW_Router::getInstance()->urlForRoute('invite_index')));
        }
    }

    public function init()
    {
        OW::getEventManager()->bind('base.add_main_console_item', array($this, 'addConsoleItem'));
        OW::getEventManager()->bind('admin.add_auth_labels', array($this, "onCollectAuthLabels"));
        $service = IISINVITE_BOL_Service::getInstance();
        OW::getEventManager()->bind(IISINVITE_BOL_Service::ON_SEND_INVITATION, array( $service, "onSendInvitation"));
    }

    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iisinvite' => array(
                    'label' => $language->text('iisinvite', 'auth_iisinvite_label'),
                    'actions' => array(
                        'invite' => $language->text('iisinvite', 'auth_action_label_invite')
                    )
                )
            )
        );
    }

}