<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisaudio
 * @since 1.0
 */

class IISPIWIK_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    /***
     * IISAUDIO_CTRL_Admin constructor.
     */
    public function __construct()
    {
        parent::__construct();

        if ( OW::getRequest()->isAjax() )
        {
            return;
        }

        $lang = OW::getLanguage();
        $this->setPageHeading($lang->text('iispiwik', 'admin_settings_title'));
        $this->setPageTitle($lang->text('iispiwik', 'admin_settings_title'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    /***
     *
     */
    public function settings()
    {


        $PiwikForm = new Form('PiwikForm');

        $lang = OW::getLanguage();
        $config = OW::getConfig();
        $configs = $config->getValues('iispiwik');

        $piwikSiteId = new textfield('piwiSiteId');
        $piwikSiteId->setValue($configs['iispiwik']);
        $PiwikForm->addElement($piwikSiteId);
        
        $saveSettings = new Submit('saveSettings');
        $saveSettings->setValue($lang->text('iispiwik', 'admin_save_settings'));
        $PiwikForm->addElement($saveSettings);

        $this->addForm($PiwikForm);

        if ( OW::getRequest()->isPost())
        {
            if ( $PiwikForm->isValid($_POST) )
            {
                $config->saveConfig('iispiwik', 'siteId', $PiwikForm->getElement('piwiSiteId')->getValue());
            }
        }
    }
}
