<?php
class IISPUBLISHFORUMTOPIC_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function index()
    {
        $this->setPageHeading(OW::getLanguage()->text('iispublishforumtopic', 'admin_settings_heading'));
        $this->setPageTitle(OW::getLanguage()->text('iispublishforumtopic', 'admin_settings_title'));
        $config =  OW::getConfig();
        $language = OW::getLanguage();

        $form = new Form('form');
        $form->setAjax();
        $form->setAjaxResetOnSuccess(false);
        $form->setAction(OW::getRouter()->urlForRoute('iispublishforumtopic.admin'));
        $form->bindJsFunction(Form::BIND_SUCCESS,'function( data ){ if(data && data.result){OW.info(\''.$language->text('iispublishforumtopic', 'settings_updated').'\')  }  }');

        $destination = new RadioField('destination');
        $destination->setRequired();
        $destination->addOptions(
            array(
                'blog' => $language->text('iispublishforumtopic', 'blog'),
                'news' => $language->text('iispublishforumtopic', 'news')
            )
        );
        if($config->configExists('iispublishforumtopic','publish_destination'))
        {
            $destination->setValue($config->getValue('iispublishforumtopic','publish_destination'));
        }
        $destination->setLabel($language->text('iispublishforumtopic', 'publish_destination'));
        $form->addElement($destination);


        $submit = new Submit('save');
        $form->addElement($submit);
        $this->addForm($form);

        if ( OW::getRequest()->isAjax() &&  OW::getRequest()->isPost() && $form->isValid($_POST) )
        {
            $data = $form->getValues();
            $config->saveConfig('iispublishforumtopic', 'publish_destination', $data['destination']);
            exit(json_encode(array('result' => true)));
        }
    }
}