<?php
/**
 * iisquestionroles
 */
/**
 * @author Yaser Alimardani <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisquestionroles
 * @since 1.0
 */

class IISQUESTIONROLES_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function init()
    {
        $service = IISQUESTIONROLES_BOL_Service::getInstance();
        OW::getEventManager()->bind('base.add_main_console_item', array($service, 'addRoleManagementConsoleItem'));
        OW::getEventManager()->bind(IISEventManager::HAS_USER_AUTHORIZE_TO_MANAGE_USERS, array($service, 'hasUserAuthorizeToManageUsers'));
        OW::getEventManager()->bind(IISEventManager::FIND_MODERATOR_FOR_USER, array($service, 'findModeratorForUser'));
        OW::getEventManager()->bind('admin.add_auth_labels', array($service, 'onCollectAuthLabels'));
        OW::getEventManager()->bind('notifications.collect_actions', array($service, 'onNotifyActions'));
    }
}