<?php
/**
 * @author Seyed Ismail Mirvakili
 * Date: 8/27/2017
 * Time: 9:15 AM
 */
class IISRAHYAB_BOL_Service
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }
        return self::$classInstance;
    }

    public function __construct()
    {
    }

    public function getPanelUsername()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'panel_username'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'panel_username');
    }

    public function getPanelPassword()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'panel_password'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'panel_password');
    }

    public function getPanelNumber()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'panel_number'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'panel_number');
    }

    public function getCompany()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'company'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'company');
    }

    public function getHost()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'host'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'host');
    }

    public function getPort()
    {
        if (!OW_Config::getInstance()->configExists('iisrahyab', 'port'))
            return null;
        return OW_Config::getInstance()->getValue('iisrahyab', 'port');
    }

    public function sendSMS(OW_Event $event)
    {
        $params = $event->getParams();
        if (!isset($params['mobile']))
            return null;
        if (!isset($params['text']))
            return null;
        $params['mobile'] = '0'.substr($params['mobile'], -10);
        $result = $this->getSMSProvider()->sendSMS(
            $this->getPanelUsername(),
            $this->getPanelPassword(),
            $this->getPanelNumber(),
            $params['mobile'],
            $params['text']
        );
        $this->addTrack($params['mobile'],$params['text'],$result[$params['mobile']],time());
        return array('result' => $result);
    }

    public function getCredit()
    {
        $result = $this->getSMSProvider()->getCredit(
            $this->getPanelUsername(),
            $this->getPanelPassword()
        );
        return array('credit' => (int)$result);
    }

    public function SMSProviderSettingIsComplete(OW_Event $event)
    {
        $result = $this->getSMSProvider()->checkSettingCompletion();
        $event->setData(array('is_complete' => $result));
    }

    public function SMSProviderSettingIsCompleteForTest()
    {
        $result = $this->getSMSProvider()->checkSettingCompletion();
        return array('is_complete' => $result);
    }

    /**
     * @return IISRAHYAB_CLASS_Provider
     */
    public function getSMSProvider()
    {
        return IISRAHYAB_CLASS_RahyabService::getInstance();
    }

    public function addTrack($mobile,$message,$smsId,$time){
        $track = new IISRAHYAB_BOL_Track();
        $track->mobile = $mobile;
        $track->message = $message;
        $track->time = $time;
        $track->smsId = $smsId;
        IISRAHYAB_BOL_TrackDao::getInstance()->save($track);
    }

    public function checkSMSStatus($smsId){
        $provider = $this->getSMSProvider();
        $result = $provider->checkStatus(
            $this->getPanelUsername(),
            $this->getPanelPassword(),
            $this->getPanelNumber(),
            $smsId
        );
        return $result;
    }

    public function getStatusString($status){
        $language = OW::getLanguage();
        switch ($status){
            case 0:
                return $language->text('iisrahyab','status_0');
            case 1:
                return $language->text('iisrahyab','status_1');
            case 2:
                return $language->text('iisrahyab','status_2');
            case 3:
                return $language->text('iisrahyab','status_3');
            case 4:
                return $language->text('iisrahyab','status_4');
            default:
                return $language->text('iisrahyab','status_0');
        }
    }
}
