<?php
/**
 * @author Seyed Ismail Mirvakili
 * Date: 8/27/2017
 * Time: 9:15 AM
 */
class IISRAHYAB_CTRL_Admin extends ADMIN_CTRL_Abstract
{


    /**
     * IISRAHYAB_CTRL_Admin constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $language = OW::getLanguage();
        $this->setPageHeading($language->text('iisrahyab', 'admin_settings_heading'));
        $this->setPageTitle($language->text('iisrahyab', 'admin_settings_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function index(array $params = array())
    {
        $currentSection = '1';

        if (array_key_exists('section', $params)) {
            $currentSection = $params['section'];
        }

        $language = OW::getLanguage();
        $config = OW::getConfig();

        if ($currentSection == '1') {
            $form = new Form('form');

            $field = new TextField('panel_username');
            $field->setRequired(true);
            $field->setLabel($language->text('iisrahyab', 'panel_username'));
            if ($config->configExists('iisrahyab', 'panel_username'))
                $field->setValue($config->getValue('iisrahyab', 'panel_username'));
            $form->addElement($field);

            $field = new TextField('panel_password');
            $field->setRequired(true);
            $field->setLabel($language->text('iisrahyab', 'panel_password'));
            if ($config->configExists('iisrahyab', 'panel_password'))
                $field->setValue($config->getValue('iisrahyab', 'panel_password'));
            $form->addElement($field);

            $field = new TextField('panel_number');
            $field->setRequired(true);
            $field->setLabel($language->text('iisrahyab', 'panel_number'));
            if ($config->configExists('iisrahyab', 'panel_number'))
                $field->setValue($config->getValue('iisrahyab', 'panel_number'));
            $form->addElement($field);

            $field = new TextField('provider_host');
            $field->setRequired(true);
            $field->setLabel($language->text('iisrahyab', 'provider_host'));
            if ($config->configExists('iisrahyab', 'host'))
                $field->setValue($config->getValue('iisrahyab', 'host'));
            $form->addElement($field);

            $field = new TextField('provider_port');
            $field->setRequired(true);
            $field->addValidator(new IntValidator());
            $field->setLabel($language->text('iisrahyab', 'provider_port'));
            if ($config->configExists('iisrahyab', 'port'))
                $field->setValue($config->getValue('iisrahyab', 'port'));
            $form->addElement($field);

            $field = new TextField('company');
            $field->setRequired(true);
            $field->setLabel($language->text('iisrahyab', 'company'));
            if ($config->configExists('iisrahyab', 'company'))
                $field->setValue($config->getValue('iisrahyab', 'company'));
            $form->addElement($field);

            $submit = new Submit('save');
            $form->addElement($submit);

            $this->addForm($form);

            if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
                $data = $form->getValues();

                if (!$config->configExists('iisrahyab', 'panel_username'))
                    $config->addConfig('iisrahyab', 'panel_username', $data['panel_username']);
                else
                    $config->saveConfig('iisrahyab', 'panel_username', $data['panel_username']);

                if (!$config->configExists('iisrahyab', 'panel_password'))
                    $config->addConfig('iisrahyab', 'panel_password', $data['panel_password']);
                else
                    $config->saveConfig('iisrahyab', 'panel_password', $data['panel_password']);

                if (!$config->configExists('iisrahyab', 'panel_number'))
                    $config->addConfig('iisrahyab', 'panel_number', $data['panel_number']);
                else
                    $config->saveConfig('iisrahyab', 'panel_number', $data['panel_number']);

                if (!$config->configExists('iisrahyab', 'host'))
                    $config->addConfig('iisrahyab', 'host', $data['provider_host']);
                else
                    $config->saveConfig('iisrahyab', 'host', $data['provider_host']);

                if (!$config->configExists('iisrahyab', 'port'))
                    $config->addConfig('iisrahyab', 'port', $data['provider_port']);
                else
                    $config->saveConfig('iisrahyab', 'port', $data['provider_port']);

                if (!$config->configExists('iisrahyab', 'company'))
                    $config->addConfig('iisrahyab', 'company', $data['company']);
                else
                    $config->saveConfig('iisrahyab', 'company', $data['company']);

                OW::getFeedback()->info(OW::getLanguage()->text('iisrahyab', 'modified_successfully'));
                $this->redirect();
            }
        }else{
            $page = 1;
            if(isset($_GET['page'])){
                $page = $_GET['page'];
            }
            $limit = 10;
            $tracks = IISRAHYAB_BOL_TrackDao::getInstance()->findAllTracks($page,$limit);
            $resultTracks = array();
            foreach ($tracks as $track){
                $result = IISRAHYAB_BOL_Service::getInstance()->checkSMSStatus($track->smsId);
                $resultTracks[] = array(
                    'text'=>$track->message,
                    'mobile'=>$track->mobile,
                    'time'=>$track->time,
                    'status'=>IISRAHYAB_BOL_Service::getInstance()->getStatusString($result)
                );
            }
            $this->addComponent('paging', new BASE_CMP_Paging($page, ceil(IISRAHYAB_BOL_TrackDao::getInstance()->findAllTrackCount() / $limit), 5));
            $this->assign('tracks', $resultTracks);
        }
        $this->assign('section',$currentSection);
        $this->assign('section1_label',OW::getLanguage()->text('iisrahyab', 'section1_label'));
        $this->assign('section2_label',OW::getLanguage()->text('iisrahyab', 'section2_label'));
        $this->assign('section1_url',OW::getRouter()->urlForRoute('iisrahyab_admin_setting_section',array('section'=>1)));
        $this->assign('section2_url',OW::getRouter()->urlForRoute('iisrahyab_admin_setting_section',array('section'=>2)));
    }

}