<?php
class IISRECAPTCHA_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function index(){

        $form = new IISRECAPTCHA_KeyPairForm();
        $this->addForm($form);


        if ( OW::getRequest()->isPost() && $form->isValid($_POST) ){

            if ( $form->process() ){
                OW::getFeedback()->info(OW::getLanguage()->text('iisrecaptcha', 'save_recaptcha_setting_success'));
                $this->redirect();
            }

            OW::getFeedback()->error(OW::getLanguage()->text('iisrecaptcha', 'save_recaptcha_setting_failed'));
            $this->redirect();
        }
        OW::getDocument()->setHeading(OW::getLanguage()->text('iisrecaptcha', 'heading_configuration'));
        OW::getDocument()->setHeadingIconClass('ow_ic_friends');

    }

}

class IISRECAPTCHA_KeyPairForm extends Form {

    public function __construct()
    {
        parent::__construct('IISRECAPTCHA_KeyPairForm');
        $field = new TextField('siteKey');
        $field->setRequired(true);
        if (OW::getConfig()->configExists("iisrecaptcha", "siteKey")){
            $field->setValue(OW::getConfig()->getValue('iisrecaptcha', 'siteKey'));
        }
        $this->addElement($field);

        $field = new TextField('secretKey');
        $field->setRequired(true);
        if (OW::getConfig()->configExists("iisrecaptcha", "secretKey")){
            $field->setValue(OW::getConfig()->getValue('iisrecaptcha', 'secretKey'));
        }
        $this->addElement($field);

        $submit = new Submit('save');
        $submit->setValue(OW::getLanguage()->text('iisrecaptcha', 'save_btn_label'));
        $this->addElement($submit);
    }

    public function process()
    {
        $values = $this->getValues();
        $service = IISRECAPTCHA_BOL_Service::getInstance();
        $service->setSiteKey(trim($values['siteKey']));
        $service->setSecretKey(trim($values['secretKey']));

        return true;
    }
}