<?php
/**
 * iissecurefileurl cron job.
 *
 * @author Yaser Alimardani <egor.bulgakov@gmail.com>
 * @package ow.ow_plugins.iissecurefileurl
 * @since 1.0
 */
class IISSECUREFILEURL_Cron extends OW_Cron
{
    const TIME_TO_LIVE = 60 * 60 * 24 * 2; //2 days

    public function __construct()
    {
        parent::__construct();

        $this->addJob('deleteExpiredUrl', 1);
    }

    public function run()
    {
        
    }

    public function deleteExpiredUrl()
    {
        $service = IISSECUREFILEURL_BOL_Service::getInstance();
        $time = time() - self::TIME_TO_LIVE;
        $service->deleteExpired($time);
    }
}