<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisshasta.bol
 * @since 1.0
 */
class IISSHASTA_BOL_SpecialCategoryDao extends OW_BaseDao
{
    private static $classInstance;

    /***
     * @return IISSHASTA_BOL_SpecialCategoryDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISSHASTA_BOL_SpecialCategory';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iisshasta_special_category';
    }

    /***
     * @param $categoryId
     * @return IISSHASTA_BOL_SpecialCategory
     */
    public function saveSpecialCategory($categoryId) {
        $category = null;
        if ($categoryId != null) {
            $example = new OW_Example();
            $example->andFieldEqual('categoryId', $categoryId);
            $category = $this->findObjectByExample($example);
        }

        if ($category != null) {
            return $category;
        }

        $category = new IISSHASTA_BOL_SpecialCategory();
        $category->categoryId = $categoryId;
        $this->save($category);
        return $category;
    }

    /***
     * @param $categoryId
     */
    public function deleteSpecialCategory($categoryId) {
        $example = new OW_Example();
        $example->andFieldEqual('categoryId', $categoryId);
        $this->deleteByExample($example);
    }
}
