<?php
/**
 * iisslideshow
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisslideshow
 * @since 1.0
 */

class IISSLIDESHOW_MCMP_ExtraWidget extends BASE_CLASS_Widget
{
    public static $uniqNamePrefix = "mobile.index-IISSLIDESHOW_MCMP_ExtraWidget-";
    /**
     * @param BASE_CLASS_WidgetParameter $paramObj
     */
    public function __construct( BASE_CLASS_WidgetParameter $paramObj )
    {
        parent::__construct();
        $uniqName = $paramObj->widgetDetails->uniqName;
        if(strpos($uniqName,IISSLIDESHOW_MCMP_ExtraWidget::$uniqNamePrefix) !== 0)
            return false;
        $albumId = intval( substr($uniqName,strlen(IISSLIDESHOW_MCMP_ExtraWidget::$uniqNamePrefix)));

        $service = IISSLIDESHOW_BOL_Service::getInstance();
        $slides = $service->getSlides($albumId);
        $slidesArray = array();
        foreach ($slides as $item) {
            $slidesArray[] = array(
                'id' => $item->id,
                'description' => $item->description
            );
        }
        $this->assign('slides', $slidesArray);

        $this->setTemplate(OW::getPluginManager()->getPlugin('iisslideshow')->getMobileCmpViewDir() . 'extra_widget.html');

        // import static files
        $jsDir = OW::getPluginManager()->getPlugin("iisslideshow")->getStaticJsUrl();
        OW::getDocument()->addScript($jsDir . "slick.js");
        OW::getDocument()->addScript($jsDir . "iisslideshow.js");

        $cssFile = OW::getPluginManager()->getPlugin('iisslideshow')->getStaticCssUrl() . 'iisslideshow.css';
        OW::getDocument()->addStyleSheet($cssFile);
    }

    public static function getAccess()
    {
        return self::ACCESS_ALL;
    }

    public static function getStandardSettingValueList()
    {
        return array(
            self::SETTING_SHOW_TITLE => false,
            self::SETTING_WRAP_IN_BOX => true,
            self::SETTING_TITLE => OW_Language::getInstance()->text('iisslideshow', 'untitled'),
            self::SETTING_ICON => self::ICON_USER
        );
    }
}
