<?php
class IISSMS_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function __construct()
    {
        parent::__construct();

        if ( OW::getRequest()->isAjax() )
        {
            return;
        }

        $lang = OW::getLanguage();

        $this->setPageHeading($lang->text('iissms', 'admin_settings_title'));
        $this->setPageTitle($lang->text('iissms', 'admin_settings_title'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function settings($params)
    {
        $sectionId = 1;
        if(isset($params['sectionId'])){
            $sectionId = $params['sectionId'];
        }
        $this->assign('sectionId', $sectionId);
        if($sectionId==1)
        {
            $this->assign('sections', IISSMS_BOL_Service::getInstance()->getAdminSections($sectionId));
            $adminForm = new Form('adminForm');
            $config = OW::getConfig();
            $adminForm->setAction(OW::getRouter()->urlForRoute('iissms-admin.section-id', array('sectionId' => $sectionId)));
            $creditThresholdField = new TextField('credit_threshold');
            $creditThresholdField->setLabel(OW::getLanguage()->text('iissms', 'credit_threshold'));
            $creditThresholdField->setValue($config->getValue('iissms', 'credit_threshold'));
            $creditThresholdField->addValidator(new IntValidator());
            $adminForm->addElement($creditThresholdField);


            $tokenResendIntervalField = new TextField('token_resend_interval');
            $tokenResendIntervalField->setLabel(OW::getLanguage()->text('iissms', 'token_resend_interval'));
            $tokenResendIntervalField->setValue($config->getValue('iissms', 'token_resend_interval'));
            $tokenResendIntervalField->addValidator(new IntValidator());
            $adminForm->addElement($tokenResendIntervalField);

            $maxTokenRequestField = new TextField('max_token_request');
            $maxTokenRequestField->setLabel(OW::getLanguage()->text('iissms', 'max_token_request'));
            $maxTokenRequestField->setValue($config->getValue('iissms', 'max_token_request'));
            $maxTokenRequestField->addValidator(new IntValidator());
            $adminForm->addElement($maxTokenRequestField);

            $removeTextLinkField = new CheckboxField('remove_text_link');
            $removeTextLinkField->setLabel(OW::getLanguage()->text('iissms', 'remove_text_link'));
            $removeTextLinkField->setValue($config->getValue('iissms', 'remove_text_link'));
            $adminForm->addElement($removeTextLinkField);

            $element = new Submit('saveSettings');
            $element->setValue(OW::getLanguage()->text('iissms', 'admin_save_settings'));
            $adminForm->addElement($element);

            if (OW::getRequest()->isPost()) {
                if ($adminForm->isValid($_POST)) {
                    $config = OW::getConfig();
                    $values = $adminForm->getValues();
                    $config->saveConfig('iissms', 'credit_threshold', $values['credit_threshold']);
                    $config->saveConfig('iissms', 'token_resend_interval', $values['token_resend_interval']);
                    $config->saveConfig('iissms', 'max_token_request', $values['max_token_request']);
                    $config->saveConfig('iissms', 'remove_text_link', $values['remove_text_link']);
                    OW::getFeedback()->info(OW::getLanguage()->text('iissms', 'user_save_success'));
                }
            }

            $this->addForm($adminForm);
        }else if($sectionId==2) {
            $this->assign('sections', IISSMS_BOL_Service::getInstance()->getAdminSections($sectionId));
            $config = OW::getConfig();
            $language = OW::getLanguage();
            $form = new Form('form');
            $form->setAction(OW::getRouter()->urlForRoute('iissms-admin.section-id', array('sectionId' => $sectionId)));

            $validPhoneNumbersField = new Textarea('validPhoneNumbers');
            $validPhoneNumbersField->setLabel($language->text('iissms', 'input_settings_valid_phone_number_list_label'));
            $validPhoneNumbersField->setDescription($language->text('iissms', 'input_settings_valid_phone_number_list_desc'));
            $form->addElement($validPhoneNumbersField);

            $submit = new Submit('save');
            $form->addElement($submit);
            $this->addForm($form);

            if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
                $data = $form->getValues();
                if (!empty(trim($data['validPhoneNumbers']))) {
                    $validPhoneNumbers = array_unique(preg_split('/' . PHP_EOL . '/', $data['validPhoneNumbers']));
                    if (!$config->configExists('iissms', 'valid_phone_numbers')) {
                        $config->addConfig('iissms', 'valid_phone_numbers', json_encode(array_map('trim', $validPhoneNumbers)));
                    } else {
                        $config->saveConfig('iissms', 'valid_phone_numbers', json_encode(array_map('trim', $validPhoneNumbers)));
                    }
                } else {
                    $config->deleteConfig('iissms', 'valid_phone_numbers');
                }
                OW::getFeedback()->info(OW::getLanguage()->text('iissms', 'settings_successfuly_saved'));
            }
            if ($config->configExists('iissms', 'valid_phone_numbers')) {
                $validPhoneNumbersField->setValue(implode(PHP_EOL, json_decode($config->getValue('iissms', 'valid_phone_numbers'))));
            }
        }
   } 
}
