<?php
/**
 * iissmtpcheck
 */
/**
 * @author Milad Heshmati
 * @package ow_plugins.iissmtpcheck
 * @since 1.0
 */

class IISSMTPCHECK_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index($params)
    {
        OW::getDocument()->setTitle(OW::getLanguage()->text('iissmtpcheck', 'admin_settings_heading'));
        OW::getDocument()->setHeading(OW::getLanguage()->text('iissmtpcheck', 'admin_settings_heading'));

        $form = new Form("form");
        $configs = OW::getConfig()->getValues('iissmtpcheck');

        $textField = new TextField('suffix');
        $textField->setLabel(OW::getLanguage()->text('iissmtpcheck', 'suffix'))->setValue($configs['suffix']);
        $form->addElement($textField);

        $submit = new Submit('submit');
        $submit->setValue(OW::getLanguage()->text('iissmtpcheck', 'save_btn_label'));
        $form->addElement($submit);

        if ( OW::getRequest()->isPost() && $form->isValid($_POST) )
        {
            $data = $form->getValues();
            OW::getConfig()->saveConfig('iissmtpcheck', 'suffix', $data['suffix']);
            OW::getFeedback()->info(OW::getLanguage()->text('iissmtpcheck', 'admin_changed_success'));
        }

        $this->addForm($form);
    }
}