<?php
/**
 * Copyright (c) 2019, Mohammad Agha Abbasloo
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Aghaabbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iisgoupsplus.classes
 * @since 1.0
 */
class IISSUBGROUPS_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function init()
    {
        $service= IISSUBGROUPS_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind('iissubgroup.check.access.create.subgroups', array($service, 'checkAccessCreateSubgroups'));
        $eventManager->bind('iissubgroup.check.access.view.subgroups', array($service, 'checkAccessViewSubgroups'));
        $eventManager->bind('iissubgroup.check.access.view.subgroup.details', array($service, 'checkAccessViewSubgroupDetails'));
        $eventManager->bind('add.group.setting.elements', array($service, 'addParentGroupField'));
        $eventManager->bind('groups_group_create_complete', array($service, 'createSubgroup'));
        $eventManager->bind('groups.list.add.where.clause', array($service, 'addFindSubGroupsWhereClause'));
        $eventManager->bind('iisgroupsplus.check.can.invite.all', array($service, 'onInviteParentUsers'));
        $eventManager->bind('iissubgroups.replace.query.group.list', array($service, 'replaceQueryGroupList'));
        $eventManager->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, array($service, 'loadStaticFiles'));
        $eventManager->bind('on.prepare.group.data', array($service, 'getParentGroupData'));
        $eventManager->bind('on.render.group.edit.buttons', array($service, 'getSubGroupDeleteConfirm'));
        $eventManager->bind('groups_on_group_delete', array($service, 'onDeleteGroup'));
        $eventManager->bind('groups_find_subgroups', array($service, 'onFindSubGroups'));
        $eventManager->bind('iissubgroups.groups_find_parent', array($service, 'onFindParentGroup'));
    }


}