<?php
/**
 * Created by PhpStorm.
 * User: Seyed Ismail Mirvakili
 * Date: 7/2/18
 * Time: 10:23 AM
 */

class IISTECHUNIT_CLASS_DbInit
{
    /**
     * Singleton instance.
     *
     * @var IISTECHUNIT_CLASS_DbInit
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return IISTECHUNIT_CLASS_DbInit
     */
    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function init()
    {
        foreach (IISTECHUNIT_BOL_Service::getInstance()->sections as $sectionArray) {
            $sectionObject = IISTECHUNIT_BOL_SectionDao::getInstance()->findByName($sectionArray['name']);
            if (isset($sectionObject))
                continue;
            if (!OW_Language::getInstance()->valueExist('iistechunit', $sectionArray['title']))
                continue;
            $section = new IISTECHUNIT_BOL_Section();
            $section->required = $sectionArray['required'];
            $section->name = $sectionArray['name'];
            $section->title = OW_Language::getInstance()->text('iistechunit', $sectionArray['title']);
            IISTECHUNIT_BOL_SectionDao::getInstance()->save($section);
        }
    }
}