<?php
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iistelegram
 * @since 1.0
 */
class IISTELEGRAM_BOL_TelegramEntryDao extends OW_BaseDao
{
    /**
     * Class constructor
     *
     */
    protected function __construct()
    {
        parent::__construct();
    }
    /**
     * Class instance
     *
     * @var IISTELEGRAM_BOL_TelegramEntryDao
     */
    private static $classInstance;

    /**
     * Returns class instance
     *
     * @return IISTELEGRAM_BOL_TelegramEntryDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'IISTELEGRAM_BOL_TelegramEntry';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iistelegram_entry';
    }

    public function countEntries( $chatId )
    {
        $ex = new OW_Example();
        $ex->andFieldEqual('chatId', $chatId);
        $ex->andFieldNotEqual('isDeleted', true);

        return $this->countByExample($ex);
    }

}
