<?php
class IISTELEGRAMIMPORT_CMP_DataImportFloatBox extends OW_Component{
    public function __construct($iconClass, $groupId)
    {
        parent::__construct();
        $isUserInGroup = GROUPS_BOL_Service::getInstance()->findUser($groupId, OW::getUser()->getId());
        if (!$isUserInGroup )
        {
            throw new Redirect404Exception();
        }
        $form = IISTELEGRAMIMPORT_BOL_Service::getInstance()->getFloatBoxImportForm($groupId);
        $this->addForm($form);

        $service = IISTELEGRAMIMPORT_BOL_Service::getInstance();
        $channelsInfo = $service->getChannelsInfo($groupId);
        $this->assign('loaderIcon',$this->getIconUrl('LoaderIcon'));
        if(isset($channelsInfo)){
            $this->assign('dataIsAvailable',true);
            $this->assign('channelsInfo',$channelsInfo);
        }else{
            $errorMessage = OW::getLanguage()->text('iistelegramimport','data_is_not_available_error_message');
            $helpUrl = 'javascript:showHelpWindow()';
            $helpTitle = OW::getLanguage()->text('iistelegramimport','telegram_widget_help');

            $this->assign('dataIsAvailable',false);
            $this->assign('errorMessage',$errorMessage);
            $this->assign('helpUrl',$helpUrl);
            $this->assign('helpTitle',$helpTitle);
        }
    }
    public function getIconUrl($name){
        return OW::getPluginManager()->getPlugin('iisgroupsplus')->getStaticUrl(). 'images/'.$name.'.gif';
    }
}