<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisthememanager
 * @since 1.0
 */
class IISTHEMEMANAGER_CMP_ThemeForm extends OW_Component
{
    /**
     * Constructor.
     */
    public function __construct( $params = null)
    {
        parent::__construct();

        if( isset($params) && $params != null ){
            $key =  $params['key'];
        }

        OW::getDocument()->addStyleSheet(OW::getPluginManager()->getPlugin('iisthememanager')->getStaticCssUrl() . 'iisthememanager.css');
        OW::getDocument()->addScript(OW::getPluginManager()->getPlugin('iisthememanager')->getStaticJsUrl() . 'iisthememanager.js');
        $themeActionController= OW::getRouter()->urlFor('IISTHEMEMANAGER_CTRL_ThemeActions', 'index');
        $service = IISTHEMEMANAGER_BOL_Service::getInstance();
        $themeObject = array();
        $edit = false;
        if( isset($key) && $key != null ){
            $themeObject = $service->getThemeArrayByKey( $key );
            $edit = true;
        }

        $lang = OW::getLanguage();

        $NewTheme = new Form('newTheme');
        $NewTheme->setEnctype(Form::ENCTYPE_MULTYPART_FORMDATA);

        $name = new TextField('themeName');
        $name->setLabel($lang->text('iisthememanager','theme_name'));
        $name->setRequired(true);
        if($edit){
            $name->setValue($themeObject['themeName']);
        }
        $NewTheme->addElement($name);

        $key = new TextField('themeKey');
        $key->setLabel($lang->text('iisthememanager','theme_key'));
        $key->addValidator(new StringValidator());                                               //todo: validator must validate the key to assure that it is english
        $key->setRequired(true);
        if($edit){
            $key->setValue($themeObject['themeKey']);
        }
        $NewTheme->addElement($key);

        $parentTheme = new Selectbox('parentTheme');
        $options = array();
        $allParentTheme = $service->getParentThemes();
        foreach ($allParentTheme as $parentThemeItem){
            $options[$parentThemeItem->key] = $parentThemeItem->title;
        }
        if($edit){
            $parentTheme->setValue($themeObject['parentTheme']);
        }
        $parentTheme->setOptions($options);
        $parentTheme->setHasInvitation(true);
        $parentTheme->setRequired(true);
        $parentTheme->setLabel($lang->text('iisthememanager','parent_theme'));
        $NewTheme->addElement($parentTheme);

        foreach ($service->colorsList as $colorName){
            $color = new TextField($colorName);                                              //todo: default values must be fetched from parent theme
            $color->setLabel($lang->text('iisthememanager',$colorName));
            if($edit){
                $color->setValue($themeObject['themeColors'][$colorName]);
            }
            $NewTheme->addElement($color);
        }
        $renderUrls = $service->urlsList;
        foreach ($service->urlsList as $key=> $urlName){
            $fileField = new FileField($urlName['name']);
            $fileField->setLabel($lang->text('iisthememanager', $urlName['name']));
            if($edit){
                $urls = $themeObject['urls'];
                if(isset($urls[$urlName['name']])){
                    $renderUrls[$key] = array_merge($renderUrls[$key],array("url"=>$urls[$urlName['name']]));
                }
            }
            $NewTheme->addElement($fileField);
        }

        $fileRemoveList = new HiddenField( 'fileRemoveList' );
        $fileRemoveList->addAttribute("id", "file_remove_list");
        $NewTheme->addElement($fileRemoveList);


        $categoryField = new CheckboxGroup('themeConfigs');
        $configs = $service->configList;
        foreach ($configs as $config ){
            $categoryField->addOption( $config['fileName'] , $lang->text('iisthememanager',$config['name']));
        }
        if($edit){
            $categoryField->setValue($themeObject['configs']);
        }
        $categoryField->setLabel(OW::getLanguage()->text('iisthememanager', 'theme_configs'));
        $NewTheme->addElement($categoryField);


        $style = new Textarea('themeStyle');
        $style->setLabel(OW::getLanguage()->text('iisthememanager', 'customize_css'));
        if($edit){
            $style->setValue($themeObject['themeStyle']);
        }
        $NewTheme->addElement($style);

        $footerTags = new Textarea('footerTags');
        $footerTags->setLabel(OW::getLanguage()->text('iisthememanager', 'footer_tags_label'));
        if($edit){
            $footerTags->setValue($themeObject['footerTags']);
        }
        $NewTheme->addElement($footerTags);

        $submit = new Submit('createTheme');
        if($edit){
            $submit->setValue(OW::getLanguage()->text('admin', 'save_btn_label'));
        }else{
            $submit->setValue(OW::getLanguage()->text('iisthememanager', 'verify_creation'));
        }
        $NewTheme->addElement($submit);

        if ( OW::getRequest()->isPost() ) {
            if ($NewTheme->isValid($_POST)) {
                $values = $NewTheme->getValues();
                if(!empty($values['themeName']) && !empty($values['themeKey'])){
                    $values = $service->processFormValues($values);
                    $service->saveNewTheme( $values, $edit, false );
                }
                OW::getFeedback()->info($lang->text('iisthememanager', 'save_success'));
                if(isset($_GET['backUri'])){
                    $service->afterThemeActionRedirect($_GET['backUri']);
                }
            }
        }
        if(isset($_GET['backUri']) && $_GET['backUri'] == 'appearance'){
            $returnUrl = OW::getRouter()->urlForRoute('admin_themes_choose');
        }else{
            $returnUrl = OW::getRouter()->urlForRoute('iisthememanager_admin_setting');
        }
        $this->addForm($NewTheme);
        $this->assign('returnUrl', $returnUrl );
        $this->assign('colorPicker',OW::getConfig()->getValue('iisthememanager', 'colorPicker'));
        $this->assign('themeActionController',$themeActionController);
        $this->assign('colorList', $service->colorsList);
        $this->assign('urlsList', $renderUrls );
        $this->assign('guideLink', OW::getPluginManager()->getPlugin('iisthememanager')->getStaticUrl().'img/Plugin_Guide.png' );
    }
}