<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisthememanager
 * @since 1.0
 */
class IISTHEMEMANAGER_CMP_ThemeList extends OW_Component
{
    /**
     * Constructor.
     */
    public function __construct( $params = null)
    {
        parent::__construct();
        $backUri ='';
        if( isset($params) && $params != null ){
            if ($params['key'] == 'appearance' || $params['key'] == 'plugin'  ){
                $backUri = '?backUri='. $params['key'];
            }
        }
        parent::__construct();
        $themeActionController= OW::getRouter()->urlFor('IISTHEMEMANAGER_CTRL_ThemeActions', 'index');
        $activeTheme =  OW::getConfig()->getValue('iisthememanager', 'activeTheme') ;
        $this->assign('themeActionController',$themeActionController);
        $this->assign('iisThemeManagerThemes',IISTHEMEMANAGER_BOL_Service::getInstance()->findAllThemes());
        $this->assign('iisThemeManagerNewTheme',OW::getRouter()->urlForRoute('create_new_theme_route').$backUri );
        $this->assign('iisThemeManagerUploadTheme',OW::getRouter()->urlForRoute('upload_theme_route').$backUri );
        $this->assign('activeTheme', $activeTheme );
        $this->assign('pluginUrl', OW::getPluginManager()->getPlugin('iisthememanager')->getUserFilesUrl() );
        $this->assign('noLogoLink', OW::getPluginManager()->getPlugin('iisthememanager')->getStaticUrl().'img/noLogo.png' );
        if(isset($activeTheme) && $activeTheme !=null){
            OW::getDocument()->addOnloadScript('
            $(window).on(\'load\', function() {
                $(\'.theme_item.iisthememanager_theme.active .theme_icon\').trigger( "click" );
            });
        ');
        }
    }
}