<?php
/**
 *
 */

/**
 * iisticketing Service.
 *
 * @author Mohammad Agha Abbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iisticketing.bol
 * @since 1.0
 */
final class IISTICKETING_BOL_TicketOrderService
{

    /**
     * @var IISTICKETING_BOL_TicketOrderDao
     */
    private $orderDao;


    /**
     * Constructor.
     */
    protected function __construct()
    {
        $this->orderDao = IISTICKETING_BOL_TicketOrderDao::getInstance();
    }

    /**
     * Singleton instance.
     *
     * @var iisterms_BOL_Service
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return IISTICKETING_BOL_TicketOrderService
     */
    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getTicketOrderList()
    {
        return $this->orderDao->findAll();
    }
    public function addOrder($title)
    {
        $orderEntity = new IISTICKETING_BOL_TicketOrder();
        $orderEntity->title = $title;
        $this->orderDao->save($orderEntity);
    }

    public function getItemForm($id)
    {
        $item = $this->getOrderById($id);
        $formName = 'edit-item';
        $submitLabel = 'edit';
        $actionRoute = OW::getRouter()->urlFor('IISTICKETING_CTRL_Admin', 'editOrderItem');

        $form = new Form($formName);
        $form->setAction($actionRoute);

        if ($item != null) {
            $idField = new HiddenField('id');
            $idField->setValue($item->id);
            $form->addElement($idField);
        }

        $fieldTitle = new TextField('title');
        $fieldTitle->setRequired();
        $fieldTitle->setInvitation(OW::getLanguage()->text('iisticketing', 'title_order_label'));
        $fieldTitle->setValue($item->title);
        $fieldTitle->setHasInvitation(true);
        $validator = new IISTICKETING_CLASS_OrderTitleValidator();
        $language = OW::getLanguage();
        $validator->setErrorMessage($language->text('iisticketing', 'title_error_already_exist'));
        $fieldTitle->addValidator($validator);
        $form->addElement($fieldTitle);

        $submit = new Submit('submit', 'button');
        $submit->setValue(OW::getLanguage()->text('base', 'ow_ic_save'));
        $form->addElement($submit);

        return $form;
    }

    public function getOrderById($id)
    {
        return $this->orderDao->findById($id);
    }

    public function editOrderItem($id, $title)
    {
        $item = $this->getOrderById($id);
        if ($item == null) {
            return;
        }
        if ($title == null) {
            $title = false;
        }
        $item->title = $title;

        $this->orderDao->save($item);
        return $item;
    }

    public function deleteOrder( $orderId )
    {
        $orderId = (int)$orderId;
        if ($orderId > 0) {

            $ticketService= IISTICKETING_BOL_TicketService::getInstance();
            $ticketService->deleteTicketOrderInformation($orderId);

            $this->orderDao->deleteById($orderId);
        }
    }

    public function findOrderById($orderId)
    {
        return $this->orderDao->findById($orderId);
    }
}