<?php
class IISTICKETING_CTRL_EditPost extends OW_ActionController
{

    public function index( array $params = null )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();

        if ( !isset($params['postId']) || !($postId = (int) $params['postId']) )
        {
            throw new Redirect404Exception();
        }

        $postDto = $ticketService->findPostById($postId);

        if ( !$postDto )
        {
            throw new Redirect404Exception();
        }

        $userId = OW::getUser()->getId();
        $ticketId = $postDto->ticketId;
        $ticketDto = $ticketService->findTicketById($ticketId);


        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets') || OW::getUser()->isAdmin();
        $isOwner=OW::getUser()->getId()==$ticketDto->userId;

        if ( !$isOwner && !$isTicketManager )
        {
            throw new AuthorizationException();
        }


        $this->assign('postId', $postId);

        $uid = IISSecurityProvider::generateUniqueId();
        $editPostForm = $this->generateEditPostForm($postDto, $uid);
        $this->addForm($editPostForm);

        $lang = OW::getLanguage();
        $router = OW::getRouter();

        $attachments = IISTICKETING_BOL_TicketAttachmentService::getInstance()->findAttachmentsByEntityIdList(array($postId),IISTICKETING_BOL_TicketAttachmentDao::POST_TYPE);
        $this->assign('attachments', $attachments);

        $attachmentCmp = new BASE_CLASS_FileAttachment('iisticketing', $uid);
        $this->addComponent('attachmentsCmp', $attachmentCmp);


        if ( OW::getRequest()->isPost() && $editPostForm->isValid($_POST) )
        {
            $values = $editPostForm->getValues();

            // update the post
            $ticketService->editPost($userId, $values, $postDto);

            $this->redirect($ticketService->getPostUrl($ticketId, $postId, true));
        }

        $ticketUrl = $ticketService->getPostUrl($ticketId, $postId);

        $lang->addKeyForJs('iisticketing', 'confirm_delete_attachment');

        OW::getDocument()->setHeading(OW::getLanguage()->text('iisticketing', 'edit_post_title'));
        OW::getDocument()->setHeadingIconClass('ow_ic_edit');

        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'delete_attachment')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $attachmentDeleteCode = $iisSecuritymanagerEvent->getData()['code'];
            $this->assign('attachmentDeleteCode',$attachmentDeleteCode);
        }

        $bcItems = array(
            array(
                'href' => $ticketUrl,
                'label' => htmlspecialchars($ticketDto->title)
            )
        );

        $breadCrumbCmp = new BASE_CMP_Breadcrumb($bcItems, $lang->text('iisticketing', 'post_location'));
        $this->addComponent('breadcrumb', $breadCrumbCmp);
    }

    /**
     * Generates edit post form.
     *
     * @param IISTICKETING_BOL_TicketPost $postDto
     * @param $uid
     * @return Form
     */
    private function generateEditPostForm( $postDto, $uid )
    {
        $form = new Form('edit-post-form');
        $form->setEnctype('multipart/form-data');
        
        $lang = OW::getLanguage();

        $postIdField = new HiddenField('post-id');
        $postIdField->setValue($postDto->id);
        $form->addElement($postIdField);

        $attachmentUid = new HiddenField('attachmentUid');
        $attachmentUid->setValue($uid);
        $attachmentUid->setRequired(true);
        $form->addElement($attachmentUid);

        $ticketIdField = new HiddenField('ticket');
        $ticketIdField->setValue($postDto->ticketId);
        $form->addElement($ticketIdField);

        $btnSet = array(BOL_TextFormatService::WS_BTN_IMAGE, BOL_TextFormatService::WS_BTN_VIDEO, BOL_TextFormatService::WS_BTN_HTML);
        $postText = new WysiwygTextarea('text','iisticketing', $btnSet);
        $postText->setRequired(true);
        $postText->setValue($postDto->text);
        $sValidator = new StringValidator(1, 50000);
        $sValidator->setErrorMessage($lang->text('iisticketing', 'chars_limit_exceeded', array('limit' => 50000)));
        $postText->addValidator($sValidator);
        $form->addElement($postText);

        $submit = new Submit('save');
        $submit->setValue($lang->text('base', 'edit_button'));
        $form->addElement($submit);

        $cancel = new Button('cancel');
        $cancel->setValue(OW::getLanguage()->text('iisticketing','cancel_button'));
        $form->addElement($cancel);

        $cancelUrl=OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$postDto->ticketId));

        OW::getDocument()->addOnloadScript('
            $("form[name=edit-post-form] input[name=cancel]").click(
                function(){
                    window.location = "'.$cancelUrl.'";
                }
            );
        ');

        return $form;
    }
}