<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 * 
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisvitrin.bol
 * @since 1.0
 */
class IISVITRIN_BOL_Service
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private $itemDao;

    private function __construct()
    {
        $this->itemDao = IISVITRIN_BOL_ItemDao::getInstance();
    }

    /***
     * @param $itemId
     * @return IISVITRIN_BOL_Item
     */
    public function getItem($itemId){
        return $this->itemDao->getItem($itemId);
    }

    /***
     * @return array
     */
    public function getItems(){
        return $this->itemDao->getItems();
    }

    /***
     * @param $title
     * @param $description
     * @param $logo
     * @param $businessModel
     * @param $language
     * @param $url
     * @param $targetMarket
     * @param $vendor
     * @return IISVITRIN_BOL_Item|null
     */
    public function saveItem($title, $description, $logo, $businessModel, $language, $url, $targetMarket, $vendor){
        $order = $this->getMaxOrder() +1;
        return $this->itemDao->saveItem($title, $description, $order, $logo, $businessModel, $language, $url, $targetMarket, $vendor);
    }

    public function getMaxOrder(){
        return $this->itemDao->getMaxOrder();
    }

    /***
     * @param $itemId
     * @param $title
     * @param $description
     * @param $logo
     * @param $businessModel
     * @param $language
     * @param $url
     * @param $targetMarket
     * @param $vendor
     * @return mixed|null
     */
    public function update($itemId, $title, $description, $logo, $businessModel, $language, $url, $targetMarket, $vendor){
        return $this->itemDao->update($itemId, $title, $description, $logo, $businessModel, $language, $url, $targetMarket, $vendor);
    }

    /***
     * @param $action
     * @param null $descriptionValue
     * @return Form
     */
    public function getDescriptionForm($action, $descriptionValue = null){
        $form = new Form('descriptionForm');
        $form->setAjax();
        $form->setAjaxResetOnSuccess(false);
        $form->setAction($action);
        $form->bindJsFunction(Form::BIND_SUCCESS,'function( data ){ if(data && data.result){OW.info(\''.OW::getLanguage()->text('iisvitrin', 'saved_successfully').'\')  }  }');

        $buttons = array(
            BOL_TextFormatService::WS_BTN_BOLD,
            BOL_TextFormatService::WS_BTN_ITALIC,
            BOL_TextFormatService::WS_BTN_UNDERLINE,
            BOL_TextFormatService::WS_BTN_IMAGE,
            BOL_TextFormatService::WS_BTN_LINK,
            BOL_TextFormatService::WS_BTN_ORDERED_LIST,
            BOL_TextFormatService::WS_BTN_UNORDERED_LIST,
            BOL_TextFormatService::WS_BTN_MORE,
            BOL_TextFormatService::WS_BTN_SWITCH_HTML,
            BOL_TextFormatService::WS_BTN_HTML
        );
        $description = new WysiwygTextarea('description','iisvitrin', $buttons);
        $description->setSize(WysiwygTextarea::SIZE_L);
        $description->setLabel(OW::getLanguage()->text('iisvitrin', 'description'));
        $description->setValue($descriptionValue);
        $description->setHasInvitation(false);
        $form->addElement($description);

        $submit = new Submit('save');
        $form->addElement($submit);

        return $form;
    }

    /***
     * @param $action
     * @param null $titleValue
     * @param null $descriptionValue
     * @param null $businessModelValue
     * @param null $languageValue
     * @param null $urlValue
     * @param null $targetMarketValue
     * @param null $vendorValue
     * @return Form
     */
    public function getItemForm($action, $titleValue = null, $descriptionValue = null, $businessModelValue = null, $languageValue = null, $urlValue = null, $targetMarketValue = null, $vendorValue = null){
        $form = new Form('item');
        $form->setAction($action);
        $form->setMethod(Form::METHOD_POST);
        $form->setEnctype(Form::ENCTYPE_MULTYPART_FORMDATA);

        $title = new TextField('title');
        $title->setRequired();
        $title->setLabel(OW::getLanguage()->text('iisvitrin', 'title'));
        $title->setValue($titleValue);
        $title->setHasInvitation(false);
        $form->addElement($title);

        $buttons = array(
            BOL_TextFormatService::WS_BTN_BOLD,
            BOL_TextFormatService::WS_BTN_ITALIC,
            BOL_TextFormatService::WS_BTN_UNDERLINE,
            BOL_TextFormatService::WS_BTN_IMAGE,
            BOL_TextFormatService::WS_BTN_LINK,
            BOL_TextFormatService::WS_BTN_ORDERED_LIST,
            BOL_TextFormatService::WS_BTN_UNORDERED_LIST,
            BOL_TextFormatService::WS_BTN_MORE,
            BOL_TextFormatService::WS_BTN_SWITCH_HTML,
            BOL_TextFormatService::WS_BTN_HTML
        );
        $description = new WysiwygTextarea('description','iisvitrin', $buttons);
        $description->setSize(WysiwygTextarea::SIZE_L);
        $description->setLabel(OW::getLanguage()->text('iisvitrin', 'description'));
        $description->setRequired();
        $description->setValue($descriptionValue);
        $description->setHasInvitation(false);
        $form->addElement($description);

        $businessModel = new TextField('businessModel');
        $businessModel->setRequired();
        $businessModel->setLabel(OW::getLanguage()->text('iisvitrin', 'business_model'));
        $businessModel->setValue($businessModelValue);
        $businessModel->setRequired();
        $businessModel->setHasInvitation(false);
        $form->addElement($businessModel);

        $logo = new FileField('logo');
        $logo->setLabel(OW::getLanguage()->text('iisvitrin', 'logo'));
        $form->addElement($logo);

        $language = new TextField('language');
        $language->setRequired();
        $language->setLabel(OW::getLanguage()->text('iisvitrin', 'language'));
        $language->setValue($languageValue);
        $language->setRequired();
        $language->setHasInvitation(false);
        $form->addElement($language);

        $url = new TextField('url');
        $url->setRequired();
        $url->setLabel(OW::getLanguage()->text('iisvitrin', 'url'));
        $url->setValue($urlValue);
        $url->setRequired();
        $url->setHasInvitation(false);
        $form->addElement($url);

        $targetMarket = new TextField('targetMarket');
        $targetMarket->setRequired();
        $targetMarket->setLabel(OW::getLanguage()->text('iisvitrin', 'targetMarket'));
        $targetMarket->setValue($targetMarketValue);
        $targetMarket->setRequired();
        $targetMarket->setHasInvitation(false);
        $form->addElement($targetMarket);

        $vendor = new TextField('vendor');
        $vendor->setRequired();
        $vendor->setLabel(OW::getLanguage()->text('iisvitrin', 'vendor'));
        $vendor->setValue($vendorValue);
        $vendor->setRequired();
        $vendor->setHasInvitation(false);
        $form->addElement($vendor);

        $submit = new Submit('submit');
        $form->addElement($submit);

        return $form;
    }

    /***
     * @param $name
     * @return string
     */
    public function getIconUrl($name){
        return OW::getPluginManager()->getPlugin('iisvitrin')->getStaticUrl().'/img/'.$name;
    }

    /***
     * @param $imageName
     * @return null|string
     */
    public function saveFile($imageName){
        if (!((int)$_FILES[$imageName]['error'] !== 0 || !is_uploaded_file($_FILES[$imageName]['tmp_name']) || !UTIL_File::validateImage($_FILES[$imageName]['name']))) {
            $logoName = IISSecurityProvider::generateUniqueId() . '.' . UTIL_File::getExtension($_FILES[$imageName]['name']);
            $tmpImgPath = $this->getSaveFileDir($logoName);
            $image = new UTIL_Image($_FILES[$imageName]['tmp_name']);
            $image->saveImage($tmpImgPath);
            return $logoName;
        }

        return null;
    }

    /***
     * @param $logoName
     * @return string
     */
    public function getFileUrl($logoName){
        return OW::getPluginManager()->getPlugin('iisvitrin')->getUserFilesUrl() . $logoName;
    }

    /***
     * @param $logoName
     * @return string
     */
    public function getSaveFileDir($logoName){
        return OW::getPluginManager()->getPlugin('iisvitrin')->getUserFilesDir() . $logoName;
    }

    /***
     * @param $itemId
     */
    public function deleteItem($itemId){
        $this->itemDao->deleteById($itemId);
    }

    /***
     * @param $item
     */
    public function saveItemByObject($item){
        $this->itemDao->save($item);
    }
}
