<?php
/**
 * Data access Object for `newsfeed_like` table.
 *
 * @package ow_plugins.newsfeed.bol
 * @since 1.0
 */
class NEWSFEED_BOL_LikeDao extends OW_BaseDao
{
    /**
     * Singleton instance.
     *
     * @var NEWSFEED_BOL_LikeDao
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return NEWSFEED_BOL_LikeDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'NEWSFEED_BOL_Like';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'newsfeed_like';
    }

    public function addLike( $userId, $entityType, $entityId )
    {
        $dto = $this->findLike($userId, $entityType, $entityId);

        if ( $dto !== null )
        {
            return $dto;
        }

        $dto = new NEWSFEED_BOL_Like();
        $dto->entityType = $entityType;
        $dto->entityId = $entityId;
        $dto->userId = $userId;
        $dto->timeStamp = time();

        $this->save($dto);

        return $dto;
    }

    public function findLike( $userId, $entityType, $entityId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);
        $example->andFieldEqual('entityId', $entityId);
        $example->andFieldEqual('entityType', $entityType);

        return $this->findObjectByExample($example);
    }

    public function removeLike( $userId, $entityType, $entityId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);
        $example->andFieldEqual('entityId', $entityId);
        $example->andFieldEqual('entityType', $entityType);

        return $this->deleteByExample($example);
    }

    public function removeLikesByUserId( $userId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);

        return $this->deleteByExample($example);
    }

    public function deleteByEntity( $entityType, $entityId )
    {
        $example = new OW_Example();

        $example->andFieldEqual('entityId', $entityId);
        $example->andFieldEqual('entityType', $entityType);

        return $this->deleteByExample($example);
    }

    public function findByUserId( $userId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);

        return $this->findListByExample($example);
    }

    public function findByEntity( $entityType, $entityId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('entityType', $entityType);
        $example->andFieldEqual('entityId', $entityId);

        return $this->findListByExample($example);
    }

    public function findByEntities( $entityTypes, $entityIds )
    {
        if (empty($entityTypes) || empty($entityIds)) {
            return array();
        }
        $example = new OW_Example();
        $example->andFieldInArray('entityType', $entityTypes);
        $example->andFieldInArray('entityId', $entityIds);

        return $this->findListByExample($example);
    }

    public function findByEntityList( $entityList )
    {
        if ( empty($entityList) )
        {
            return array();
        }

        $entityListCondition = array();

        foreach ( $entityList as $entity )
        {
            $entityListCondition[] = 'entityType="' . $entity['entityType'] . '" AND entityId="' . $entity['entityId'] . '"';
        }

        $query = 'SELECT * FROM ' . $this->getTableName() . ' WHERE ' . implode(' OR ', $entityListCondition);

        return $this->dbo->queryForObjectList($query, $this->getDtoClassName());
    }



    public function findCountByEntity( $entityType, $entityId )
    {
        $example = new OW_Example();
        $example->andFieldEqual('entityType', $entityType);
        $example->andFieldEqual('entityId', $entityId);

        return $this->countByExample($example);
    }
}