<?php
/**
 * Data Transfer Object for `notifications_notification` table.
 *
 * @package notifications.bol
 * @since 1.0
 */
class NOTIFICATIONS_BOL_Notification extends OW_Entity
{
    /**
     * @var string
     */
    public $entityType;

    /**
     * @var string
     */
    public $entityId;

    /**
     * @var int
     */
    public $userId;

    /**
     *
     * @var string
     */
    public $pluginKey;

    /**
     * @var int
     */
    public $timeStamp;

    /**
     *
     * @var int
     */
    public $viewed = false;

    /**
     *
     * @var int
     */
    public $sent = false;

    /**
     *
     * @var int
     */
    public $active = true;

    /**
     *
     * @var string
     */
    public $action;

    /**
     *
     * @var int
    */
    public $dataId;

    public function setData( $data )
    {
        $string = NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->convertDataToString($data);
        $id = NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->findIdByDataString($string);
        if(empty($id)){
            $id = NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->insert($string);
            if( !isset($id) || intval($id) <= 0 ) {
                $id = NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->findIdByDataString($string);
                OW::getLogger()->writeLog(OW_Log::WARNING, 'notification_data_id_is_zero',
                    ["string" => $string, "returned_id" => $id, "real_id" => $id]);
            }
        }
        $this->dataId = $id;
    }

    public function getData()
    {
        if (!isset($this->dataId)) {
            return null;
        }
        $string = NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->findDataById($this->dataId);
        return NOTIFICATIONS_BOL_NotificationDataDao::getInstance()->convertStringToData($string);
    }
}
